/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.client.AbstractReplyCallback;
import com.allanbank.mongodb.connection.message.Reply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReplyResultCallback
extends AbstractReplyCallback<List<Document>> {
    private final String myReplyField;

    public ReplyResultCallback(Callback<List<Document>> callback) {
        this("results", callback);
    }

    public ReplyResultCallback(String string, Callback<List<Document>> callback) {
        super(callback);
        this.myReplyField = string;
    }

    @Override
    protected List<Document> convert(Reply reply) throws MongoDbException {
        List<Document> list = Collections.emptyList();
        List<Document> list2 = reply.getResults();
        if (list2.size() == 1) {
            Document document = list2.get(0);
            List<DocumentElement> list3 = document.find(DocumentElement.class, this.myReplyField, ".*");
            if (!list3.isEmpty()) {
                list = new ArrayList<Document>();
                for (DocumentElement documentElement : list3) {
                    list.add(documentElement.getDocument());
                }
            }
        }
        return list;
    }
}

