/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.client;

import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoCursorControl;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.StreamCallback;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.DocumentAssignable;
import com.allanbank.mongodb.client.AbstractClient;
import com.allanbank.mongodb.client.ClientImpl;
import com.allanbank.mongodb.connection.ClusterType;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.Message;
import java.util.logging.Logger;

public class SerialClientImpl
extends AbstractClient {
    protected static final boolean ASSERTIONS_ENABLED;
    protected static final Logger LOG;
    private Connection myConnection;
    private final ClientImpl myDelegate;

    public SerialClientImpl(ClientImpl clientImpl) {
        this.myDelegate = clientImpl;
    }

    @Override
    public void close() {
        super.close();
        this.myConnection = null;
    }

    @Override
    public ClusterType getClusterType() {
        return this.myDelegate.getClusterType();
    }

    @Override
    public MongoClientConfiguration getConfig() {
        return this.myDelegate.getConfig();
    }

    @Override
    public Durability getDefaultDurability() {
        return this.myDelegate.getDefaultDurability();
    }

    @Override
    public ReadPreference getDefaultReadPreference() {
        return this.myDelegate.getDefaultReadPreference();
    }

    @Override
    public MongoIterator<Document> restart(DocumentAssignable documentAssignable) throws IllegalArgumentException {
        return this.myDelegate.restart(documentAssignable);
    }

    @Override
    public MongoCursorControl restart(StreamCallback<Document> streamCallback, DocumentAssignable documentAssignable) throws IllegalArgumentException {
        return this.myDelegate.restart(streamCallback, documentAssignable);
    }

    @Override
    protected Connection findConnection(Message message, Message message2) throws MongoDbException {
        if (this.myConnection == null || !this.myConnection.isOpen()) {
            this.myConnection = this.myDelegate.findConnection(message, message2);
        }
        return this.myConnection;
    }

    static {
        LOG = Logger.getLogger(SerialClientImpl.class.getCanonicalName());
        ASSERTIONS_ENABLED = SerialClientImpl.class.desiredAssertionStatus();
    }
}

