/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection;

import com.allanbank.mongodb.Callback;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FutureCallback<V>
implements Future<V>,
Callback<V> {
    public static final Class<?> CLASS = FutureCallback.class;
    private volatile boolean myCancelled = false;
    private final Lock myLock = new ReentrantLock();
    private final Condition myNoResultCondition = this.myLock.newCondition();
    private volatile boolean mySet = false;
    private volatile Throwable myThrown = null;
    private volatile V myValue = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(V v) {
        this.myLock.lock();
        try {
            this.myValue = v;
            this.mySet = true;
            this.myNoResultCondition.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (this.myValue == null && this.myThrown == null && !this.myCancelled) {
            this.myLock.lock();
            try {
                this.myCancelled = true;
                this.myNoResultCondition.signalAll();
            }
            finally {
                this.myLock.unlock();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exception(Throwable throwable) {
        this.myLock.lock();
        try {
            this.myThrown = throwable;
            this.mySet = true;
            this.myNoResultCondition.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get() throws InterruptedException, ExecutionException {
        this.myLock.lock();
        try {
            while (!this.isDone()) {
                this.myNoResultCondition.await();
            }
        }
        finally {
            this.myLock.unlock();
        }
        if (this.myThrown != null) {
            throw new ExecutionException(this.myThrown);
        }
        if (this.myCancelled) {
            throw new InterruptedException();
        }
        return this.myValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean bl = false;
        this.myLock.lock();
        try {
            bl = this.isDone();
            long l2 = timeUnit.toNanos(l);
            while (!bl && l2 >= 0L) {
                l2 = this.myNoResultCondition.awaitNanos(l2);
                bl = this.isDone();
            }
        }
        finally {
            this.myLock.unlock();
        }
        if (this.myThrown != null) {
            throw new ExecutionException(this.myThrown);
        }
        if (this.myCancelled) {
            throw new InterruptedException();
        }
        if (!bl) {
            throw new TimeoutException();
        }
        return this.myValue;
    }

    @Override
    public boolean isCancelled() {
        return this.myCancelled;
    }

    @Override
    public boolean isDone() {
        return this.mySet || this.myCancelled;
    }
}

