/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.auth;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.Credential;
import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.Message;
import com.allanbank.mongodb.connection.auth.Authenticator;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.connection.proxy.AbstractProxyConnection;
import com.allanbank.mongodb.error.MongoDbAuthenticationException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuthenticatingConnection
extends AbstractProxyConnection {
    public static final String ADMIN_DB_NAME = "admin";
    public static final Logger LOG = Logger.getLogger(AuthenticatingConnection.class.getName());
    private final Map<String, Authenticator> myAuthenticators = new ConcurrentHashMap<String, Authenticator>();
    private final Map<String, MongoDbException> myFailures = new ConcurrentHashMap<String, MongoDbException>();

    public AuthenticatingConnection(Connection connection, MongoClientConfiguration mongoClientConfiguration) {
        super(connection, mongoClientConfiguration);
        Collection<Credential> collection = mongoClientConfiguration.getCredentials();
        for (Credential credential : collection) {
            Authenticator authenticator = credential.authenticator();
            authenticator.startAuthentication(credential, connection);
            if (collection.size() > 1) {
                try {
                    if (authenticator.result()) continue;
                    this.myFailures.put(credential.getDatabase(), new MongoDbAuthenticationException("Authentication failed for the " + credential.getDatabase() + " database."));
                }
                catch (MongoDbException mongoDbException) {
                    this.myFailures.put(credential.getDatabase(), mongoDbException);
                }
                continue;
            }
            this.myAuthenticators.put(credential.getDatabase(), authenticator);
        }
    }

    @Override
    public String send(Message message, Callback<Reply> callback) throws MongoDbException {
        this.ensureAuthenticated(message);
        return super.send(message, callback);
    }

    @Override
    public String send(Message message, Message message2, Callback<Reply> callback) throws MongoDbException {
        this.ensureAuthenticated(message);
        this.ensureAuthenticated(message2);
        return super.send(message, message2, callback);
    }

    public String toString() {
        return "Auth(" + this.getProxiedConnection() + ")";
    }

    @Override
    protected Connection getProxiedConnection() {
        Connection connection = super.getProxiedConnection();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureAuthenticated(Message message) throws MongoDbAuthenticationException {
        if (!this.myAuthenticators.isEmpty()) {
            Iterator<Map.Entry<String, Authenticator>> iterator = this.myAuthenticators.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Authenticator> entry = iterator.next();
                try {
                    if (entry.getValue().result()) continue;
                    this.myFailures.put(entry.getKey(), new MongoDbAuthenticationException("Authentication failed for the " + entry.getKey() + " database."));
                }
                catch (MongoDbException mongoDbException) {
                    LOG.log(Level.WARNING, "Authentication failed: " + mongoDbException.getMessage(), mongoDbException);
                    this.myFailures.put(entry.getKey(), mongoDbException);
                }
                finally {
                    iterator.remove();
                }
            }
        }
        if (this.myFailures.containsKey(message.getDatabaseName())) {
            throw new MongoDbAuthenticationException(this.myFailures.get(message.getDatabaseName()));
        }
    }
}

