/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.auth;

import com.allanbank.mongodb.Credential;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.client.AbstractReplyCallback;
import com.allanbank.mongodb.client.AbstractValidatingReplyCallback;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.FutureCallback;
import com.allanbank.mongodb.connection.auth.Authenticator;
import com.allanbank.mongodb.connection.message.Command;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.error.MongoDbAuthenticationException;
import com.allanbank.mongodb.util.IOUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class MongoDbAuthenticator
implements Authenticator {
    public static final Charset ASCII = Charset.forName("US-ASCII");
    protected FutureCallback<Boolean> myResults = new FutureCallback();

    @Override
    public MongoDbAuthenticator clone() {
        try {
            MongoDbAuthenticator mongoDbAuthenticator = (MongoDbAuthenticator)super.clone();
            mongoDbAuthenticator.myResults = new FutureCallback();
            return mongoDbAuthenticator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new MongoDbAuthenticator();
        }
    }

    public String passwordHash(Credential credential) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        return this.passwordHash(messageDigest, credential);
    }

    @Override
    public boolean result() throws MongoDbAuthenticationException {
        try {
            return this.myResults.get();
        }
        catch (InterruptedException interruptedException) {
            throw new MongoDbAuthenticationException(interruptedException);
        }
        catch (ExecutionException executionException) {
            throw new MongoDbAuthenticationException(executionException);
        }
    }

    @Override
    public void startAuthentication(Credential credential, Connection connection) throws MongoDbAuthenticationException {
        try {
            DocumentBuilder documentBuilder = BuilderFactory.start();
            documentBuilder.addInteger("getnonce", 1);
            connection.send(new Command(credential.getDatabase(), documentBuilder.build()), new NonceReplyCallback(credential, connection));
        }
        catch (MongoDbException mongoDbException) {
            this.myResults.exception(mongoDbException);
            throw mongoDbException;
        }
    }

    protected String passwordHash(MessageDigest messageDigest, Credential credential) {
        char[] cArray = credential.getPassword();
        ByteBuffer byteBuffer = ASCII.encode(CharBuffer.wrap(cArray));
        messageDigest.update((credential.getUserName() + ":mongo:").getBytes(ASCII));
        messageDigest.update(byteBuffer.array(), 0, byteBuffer.limit());
        Arrays.fill(cArray, ' ');
        Arrays.fill(byteBuffer.array(), (byte)0);
        return IOUtils.toHex(messageDigest.digest());
    }

    private class NonceReplyCallback
    extends AbstractValidatingReplyCallback {
        private final Connection myConnection;
        private final Credential myCredential;

        public NonceReplyCallback(Credential credential, Connection connection) {
            this.myCredential = credential;
            this.myConnection = connection;
        }

        @Override
        public void exception(Throwable throwable) {
            MongoDbAuthenticator.this.myResults.exception(throwable);
        }

        @Override
        protected void handle(Reply reply) {
            Object object;
            MongoDbException mongoDbException = this.asError(reply);
            if (mongoDbException != null) {
                this.exception(mongoDbException);
                return;
            }
            StringElement stringElement = null;
            if (reply.getResults().size() > 0) {
                object = reply.getResults().get(0);
                stringElement = object.get(StringElement.class, "nonce");
                if (stringElement == null) {
                    this.exception(new MongoDbAuthenticationException("Bad response from nonce request."));
                    return;
                }
            } else {
                this.exception(new MongoDbAuthenticationException("Bad response from nonce request."));
                return;
            }
            try {
                object = MessageDigest.getInstance("MD5");
                String string = MongoDbAuthenticator.this.passwordHash((MessageDigest)object, this.myCredential);
                String string2 = stringElement.getValue() + this.myCredential.getUserName() + string;
                ((MessageDigest)object).reset();
                ((MessageDigest)object).update(string2.getBytes(ASCII));
                byte[] byArray = ((MessageDigest)object).digest();
                DocumentBuilder documentBuilder = BuilderFactory.start();
                documentBuilder.addInteger("authenticate", 1);
                documentBuilder.add(stringElement.getName(), stringElement.getValue());
                documentBuilder.addString("user", this.myCredential.getUserName());
                documentBuilder.addString("key", IOUtils.toHex(byArray));
                this.myConnection.send(new Command(this.myCredential.getDatabase(), documentBuilder.build()), new AuthenticateReplyCallback(MongoDbAuthenticator.this.myResults));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.exception(new MongoDbAuthenticationException(noSuchAlgorithmException));
            }
        }
    }

    private static class AuthenticateReplyCallback
    extends AbstractReplyCallback<Boolean> {
        public AuthenticateReplyCallback(FutureCallback<Boolean> futureCallback) {
            super(futureCallback);
        }

        @Override
        protected Boolean convert(Reply reply) throws MongoDbException {
            int n;
            Document document;
            Element element;
            boolean bl = false;
            List<Document> list = reply.getResults();
            if (list.size() == 1 && (element = (document = list.get(0)).get("ok")) != null && (n = this.toInt(element)) == 1) {
                bl = true;
            }
            return bl;
        }
    }
}

