/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.bootstrap;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.connection.ClusterType;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.ConnectionFactory;
import com.allanbank.mongodb.connection.FutureCallback;
import com.allanbank.mongodb.connection.ReconnectStrategy;
import com.allanbank.mongodb.connection.auth.AuthenticationConnectionFactory;
import com.allanbank.mongodb.connection.message.IsMaster;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.connection.rs.ReplicaSetConnectionFactory;
import com.allanbank.mongodb.connection.sharded.ShardedConnectionFactory;
import com.allanbank.mongodb.connection.socket.SocketConnectionFactory;
import com.allanbank.mongodb.connection.state.ServerState;
import com.allanbank.mongodb.error.CannotConnectException;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BootstrapConnectionFactory
implements ConnectionFactory {
    protected static final Logger LOG = Logger.getLogger(BootstrapConnectionFactory.class.getCanonicalName());
    private final MongoClientConfiguration myConfig;
    private ConnectionFactory myDelegate = null;

    public BootstrapConnectionFactory(MongoClientConfiguration mongoClientConfiguration) {
        this.myConfig = mongoClientConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        ProxiedConnectionFactory proxiedConnectionFactory = new SocketConnectionFactory(this.myConfig);
        if (this.myConfig.isAuthenticating()) {
            proxiedConnectionFactory = new AuthenticationConnectionFactory(proxiedConnectionFactory, this.myConfig);
        }
        try {
            for (InetSocketAddress inetSocketAddress : this.myConfig.getServerAddresses()) {
                Connection connection = null;
                FutureCallback<Reply> futureCallback = new FutureCallback<Reply>();
                try {
                    connection = proxiedConnectionFactory.connect(new ServerState(inetSocketAddress), this.myConfig);
                    connection.send(new IsMaster(), futureCallback);
                    Reply reply = futureCallback.get();
                    IOUtils.close(connection);
                    List<Document> list = reply.getResults();
                    if (list.isEmpty()) continue;
                    Document document = list.get(0);
                    if (this.isMongos(document)) {
                        LOG.fine("Sharded bootstrap to " + inetSocketAddress + ".");
                        this.myDelegate = new ShardedConnectionFactory(proxiedConnectionFactory, this.myConfig);
                    } else if (this.isReplicationSet(document)) {
                        LOG.fine("Replica-set bootstrap to " + inetSocketAddress + ".");
                        this.myDelegate = new ReplicaSetConnectionFactory(proxiedConnectionFactory, this.myConfig);
                    } else {
                        LOG.fine("Simple MongoDB bootstrap to " + inetSocketAddress + ".");
                        this.myDelegate = proxiedConnectionFactory;
                    }
                    proxiedConnectionFactory = null;
                    return;
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "I/O error during bootstrap to " + inetSocketAddress + ".", iOException);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.WARNING, "Interrupted during bootstrap to " + inetSocketAddress + ".", interruptedException);
                }
                catch (ExecutionException executionException) {
                    LOG.log(Level.WARNING, "Error during bootstrap to " + inetSocketAddress + ".", executionException);
                }
                finally {
                    IOUtils.close(connection, Level.WARNING, "I/O error shutting down bootstrap connection to " + inetSocketAddress + ".");
                }
            }
        }
        finally {
            IOUtils.close(proxiedConnectionFactory);
        }
    }

    @Override
    public void close() {
        IOUtils.close(this.myDelegate);
    }

    @Override
    public Connection connect() throws IOException {
        return this.getDelegate().connect();
    }

    @Override
    public ClusterType getClusterType() {
        return this.getDelegate().getClusterType();
    }

    @Override
    public ReconnectStrategy getReconnectStrategy() {
        return this.getDelegate().getReconnectStrategy();
    }

    protected ConnectionFactory getDelegate() {
        if (this.myDelegate == null) {
            this.bootstrap();
            if (this.myDelegate == null) {
                LOG.log(Level.WARNING, "Could not bootstrap a connection to the MongoDB servers.");
                throw new CannotConnectException("Could not bootstrap a connection to the MongoDB servers.");
            }
        }
        return this.myDelegate;
    }

    protected void setDelegate(ConnectionFactory connectionFactory) {
        this.myDelegate = connectionFactory;
    }

    private boolean isMongos(Document document) {
        Element element = document.get("msg");
        if (element instanceof StringElement) {
            return "isdbgrid".equals(((StringElement)element).getValue());
        }
        return false;
    }

    private boolean isReplicationSet(Document document) {
        return document.get("setName") instanceof StringElement;
    }
}

