/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.connection.Message;
import com.allanbank.mongodb.connection.Operation;

public abstract class AbstractMessage
implements Message {
    public static final int HEADER_SIZE = 16;
    protected String myCollectionName;
    protected String myDatabaseName;
    private final ReadPreference myReadPreference;

    public AbstractMessage() {
        this.myDatabaseName = "";
        this.myCollectionName = "";
        this.myReadPreference = ReadPreference.PRIMARY;
    }

    public AbstractMessage(String string, String string2, ReadPreference readPreference) {
        this.myDatabaseName = string;
        this.myCollectionName = string2;
        this.myReadPreference = readPreference;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && this.getClass() == object.getClass()) {
            AbstractMessage abstractMessage = (AbstractMessage)object;
            bl = this.myCollectionName.equals(abstractMessage.myCollectionName) && this.myDatabaseName.equals(abstractMessage.myDatabaseName) && this.myReadPreference.equals(abstractMessage.myReadPreference);
        }
        return bl;
    }

    public String getCollectionName() {
        return this.myCollectionName;
    }

    @Override
    public String getDatabaseName() {
        return this.myDatabaseName;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.myReadPreference;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.myCollectionName.hashCode();
        n = 31 * n + this.myDatabaseName.hashCode();
        n = 31 * n + this.myReadPreference.hashCode();
        return n;
    }

    protected void init(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            this.myDatabaseName = string.substring(0, n);
            this.myCollectionName = string.substring(n + 1);
        } else {
            this.myDatabaseName = string;
        }
    }

    protected void writeHeader(BsonOutputStream bsonOutputStream, int n, int n2, Operation operation, int n3) {
        bsonOutputStream.writeInt(n3);
        bsonOutputStream.writeInt(n);
        bsonOutputStream.writeInt(n2);
        bsonOutputStream.writeInt(operation.getCode());
    }
}

