/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.SizeOfVisitor;
import com.allanbank.mongodb.connection.Operation;
import com.allanbank.mongodb.connection.message.AbstractMessage;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.IOException;

public class Delete
extends AbstractMessage {
    public static final int SINGLE_DELETE_BIT = 1;
    private final Document myQuery;
    private int myQuerySize;
    private final boolean mySingleDelete;

    public Delete(BsonInputStream bsonInputStream) throws IOException {
        bsonInputStream.readInt();
        this.init(bsonInputStream.readCString());
        int n = bsonInputStream.readInt();
        this.myQuery = bsonInputStream.readDocument();
        this.mySingleDelete = (n & 1) == 1;
        this.myQuerySize = -1;
    }

    public Delete(String string, String string2, Document document, boolean bl) {
        super(string, string2, ReadPreference.PRIMARY);
        this.myQuery = document;
        this.mySingleDelete = bl;
        this.myQuerySize = -1;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Delete delete = (Delete)object;
            bl = super.equals(object) && this.mySingleDelete == delete.mySingleDelete && this.myQuery.equals(delete.myQuery);
        }
        return bl;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.mySingleDelete ? 1 : 3);
        n = 31 * n + this.myQuery.hashCode();
        return n;
    }

    public boolean isSingleDelete() {
        return this.mySingleDelete;
    }

    @Override
    public void validateSize(SizeOfVisitor sizeOfVisitor, int n) throws DocumentToLargeException {
        if (this.myQuerySize < 0) {
            sizeOfVisitor.reset();
            this.myQuery.accept(sizeOfVisitor);
            this.myQuerySize = sizeOfVisitor.getSize();
        }
        if (n < this.myQuerySize) {
            throw new DocumentToLargeException(this.myQuerySize, n, this.myQuery);
        }
    }

    @Override
    public void write(int n, BsonOutputStream bsonOutputStream) throws IOException {
        int n2 = 0;
        if (this.mySingleDelete) {
            ++n2;
        }
        int n3 = 16;
        n3 += 4;
        n3 += bsonOutputStream.sizeOfCString(this.myDatabaseName, ".", this.myCollectionName);
        n3 += 4;
        this.writeHeader(bsonOutputStream, n, 0, Operation.DELETE, n3 += bsonOutputStream.sizeOf(this.myQuery));
        bsonOutputStream.writeInt(0);
        bsonOutputStream.writeCString(this.myDatabaseName, ".", this.myCollectionName);
        bsonOutputStream.writeInt(n2);
        bsonOutputStream.writeDocument(this.myQuery);
    }
}

