/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.SizeOfVisitor;
import com.allanbank.mongodb.connection.Operation;
import com.allanbank.mongodb.connection.message.AbstractMessage;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.IOException;

public class GetMore
extends AbstractMessage {
    private final long myCursorId;
    private final int myNumberToReturn;

    public GetMore(BsonInputStream bsonInputStream) throws IOException {
        bsonInputStream.readInt();
        this.init(bsonInputStream.readCString());
        this.myNumberToReturn = bsonInputStream.readInt();
        this.myCursorId = bsonInputStream.readLong();
    }

    public GetMore(String string, String string2, long l, int n, ReadPreference readPreference) {
        super(string, string2, readPreference);
        this.myCursorId = l;
        this.myNumberToReturn = n;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            GetMore getMore = (GetMore)object;
            bl = super.equals(object) && this.myCursorId == getMore.myCursorId && this.myNumberToReturn == getMore.myNumberToReturn;
        }
        return bl;
    }

    public long getCursorId() {
        return this.myCursorId;
    }

    public int getNumberToReturn() {
        return this.myNumberToReturn;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (int)(this.myCursorId >> 32);
        n = 31 * n + (int)this.myCursorId;
        n = 31 * n + this.myNumberToReturn;
        return n;
    }

    @Override
    public void validateSize(SizeOfVisitor sizeOfVisitor, int n) throws DocumentToLargeException {
    }

    @Override
    public void write(int n, BsonOutputStream bsonOutputStream) throws IOException {
        int n2 = 16;
        n2 += 4;
        n2 += bsonOutputStream.sizeOfCString(this.myDatabaseName, ".", this.myCollectionName);
        n2 += 4;
        this.writeHeader(bsonOutputStream, n, 0, Operation.GET_MORE, n2 += 8);
        bsonOutputStream.writeInt(0);
        bsonOutputStream.writeCString(this.myDatabaseName, ".", this.myCollectionName);
        bsonOutputStream.writeInt(this.myNumberToReturn);
        bsonOutputStream.writeLong(this.myCursorId);
    }
}

