/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.message;

import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.connection.Operation;
import java.io.IOException;

public class Header {
    public static final int SIZE = 16;
    private final int myLength;
    private final Operation myOperation;
    private final int myRequestId;
    private final int myResponseId;

    public Header(BsonInputStream bsonInputStream) throws IOException {
        this.myLength = bsonInputStream.readInt();
        this.myRequestId = bsonInputStream.readInt();
        this.myResponseId = bsonInputStream.readInt();
        this.myOperation = Operation.fromCode(bsonInputStream.readInt());
    }

    public Header(int n, int n2, int n3, Operation operation) {
        this.myLength = n;
        this.myRequestId = n2;
        this.myResponseId = n3;
        this.myOperation = operation;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Header header = (Header)object;
            bl = this.myLength == header.myLength && this.myOperation == header.myOperation && this.myRequestId == header.myRequestId && this.myResponseId == header.myResponseId;
        }
        return bl;
    }

    public int getLength() {
        return this.myLength;
    }

    public Operation getOperation() {
        return this.myOperation;
    }

    public int getRequestId() {
        return this.myRequestId;
    }

    public int getResponseId() {
        return this.myResponseId;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.myLength;
        n = 31 * n + this.myRequestId;
        n = 31 * n + this.myResponseId;
        n = 31 * n + this.myOperation.hashCode();
        return n;
    }
}

