/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.SizeOfVisitor;
import com.allanbank.mongodb.connection.Operation;
import com.allanbank.mongodb.connection.message.AbstractMessage;
import com.allanbank.mongodb.connection.message.Header;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.IOException;

public class Query
extends AbstractMessage {
    public static final int AWAIT_DATA_FLAG_BIT = 32;
    public static final int DEFAULT_BATCH_SIZE = 101;
    public static final int EXHAUST_FLAG_BIT = 64;
    public static final int NO_CURSOR_TIMEOUT_FLAG_BIT = 16;
    public static final int OPLOG_REPLAY_FLAG_BIT = 8;
    public static final int PARTIAL_FLAG_BIT = 128;
    public static final int REPLICA_OK_FLAG_BIT = 4;
    public static final int TAILABLE_CURSOR_FLAG_BIT = 2;
    private final boolean myAwaitData;
    private final int myBatchSize;
    private final boolean myExhaust;
    private final int myLimit;
    private int myMessageSize;
    private final boolean myNoCursorTimeout;
    private final int myNumberToReturn;
    private final int myNumberToSkip;
    private final boolean myPartial;
    private final Document myQuery;
    private final Document myReturnFields;
    private final boolean myTailable;

    public Query(Header header, BsonInputStream bsonInputStream) throws IOException {
        long l = bsonInputStream.getBytesRead();
        long l2 = l + (long)header.getLength() - 16L;
        int n = bsonInputStream.readInt();
        this.init(bsonInputStream.readCString());
        this.myNumberToSkip = bsonInputStream.readInt();
        this.myNumberToReturn = bsonInputStream.readInt();
        this.myQuery = bsonInputStream.readDocument();
        this.myReturnFields = bsonInputStream.getBytesRead() < l2 ? bsonInputStream.readDocument() : null;
        this.myAwaitData = (n & 0x20) == 32;
        this.myExhaust = (n & 0x40) == 64;
        this.myNoCursorTimeout = (n & 0x10) == 16;
        this.myPartial = (n & 0x80) == 128;
        this.myTailable = (n & 2) == 2;
        this.myLimit = 0;
        this.myBatchSize = 0;
        this.myMessageSize = -1;
    }

    public Query(String string, String string2, Document document, Document document2, int n, int n2, int n3, boolean bl, ReadPreference readPreference, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        super(string, string2, readPreference);
        this.myQuery = document;
        this.myReturnFields = document2;
        this.myLimit = n2;
        this.myBatchSize = n;
        this.myNumberToSkip = n3;
        this.myTailable = bl;
        this.myNoCursorTimeout = bl2;
        this.myAwaitData = bl3;
        this.myExhaust = bl4;
        this.myPartial = bl5;
        this.myMessageSize = -1;
        this.myNumberToReturn = this.isBatchSizeSet() ? (this.isLimitSet() && this.myLimit <= this.myBatchSize ? -this.myLimit : this.myBatchSize) : (this.isLimitSet() && this.myLimit <= 101 ? -this.myLimit : 0);
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Query query = (Query)object;
            bl = super.equals(object) && this.myAwaitData == query.myAwaitData && this.myExhaust == query.myExhaust && this.myNoCursorTimeout == query.myNoCursorTimeout && this.myPartial == query.myPartial && this.myTailable == query.myTailable && this.myBatchSize == query.myBatchSize && this.myLimit == query.myLimit && this.myNumberToReturn == query.myNumberToReturn && this.myNumberToSkip == query.myNumberToSkip && this.myQuery.equals(query.myQuery) && (this.myReturnFields == query.myReturnFields || this.myReturnFields != null && this.myReturnFields.equals(query.myReturnFields));
        }
        return bl;
    }

    public int getBatchSize() {
        return this.myBatchSize;
    }

    public int getLimit() {
        return this.myLimit;
    }

    public int getNumberToReturn() {
        return this.myNumberToReturn;
    }

    public int getNumberToSkip() {
        return this.myNumberToSkip;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    public Document getReturnFields() {
        return this.myReturnFields;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myAwaitData ? 1 : 3);
        n = 31 * n + (this.myExhaust ? 1 : 7);
        n = 31 * n + (this.myNoCursorTimeout ? 1 : 11);
        n = 31 * n + (this.myPartial ? 1 : 13);
        n = 31 * n + (this.myTailable ? 1 : 19);
        n = 31 * n + this.myBatchSize;
        n = 31 * n + this.myLimit;
        n = 31 * n + this.myNumberToReturn;
        n = 31 * n + this.myNumberToSkip;
        n = 31 * n + this.myQuery.hashCode();
        n = 31 * n + (this.myReturnFields == null ? 1 : this.myReturnFields.hashCode());
        return n;
    }

    public boolean isAwaitData() {
        return this.myAwaitData;
    }

    public boolean isBatchSizeSet() {
        return 0 < this.myBatchSize;
    }

    public boolean isExhaust() {
        return this.myExhaust;
    }

    public boolean isLimitSet() {
        return 0 < this.myLimit;
    }

    public boolean isNoCursorTimeout() {
        return this.myNoCursorTimeout;
    }

    public boolean isPartial() {
        return this.myPartial;
    }

    public boolean isTailable() {
        return this.myTailable;
    }

    @Override
    public void validateSize(SizeOfVisitor sizeOfVisitor, int n) throws DocumentToLargeException {
        if (this.myMessageSize < 0) {
            sizeOfVisitor.reset();
            if (this.myQuery != null) {
                this.myQuery.accept(sizeOfVisitor);
            }
            if (this.myReturnFields != null) {
                this.myReturnFields.accept(sizeOfVisitor);
            }
            this.myMessageSize = sizeOfVisitor.getSize();
        }
        if (n < this.myMessageSize) {
            throw new DocumentToLargeException(this.myMessageSize, n, this.myQuery);
        }
    }

    @Override
    public void write(int n, BsonOutputStream bsonOutputStream) throws IOException {
        int n2 = 0;
        if (this.myAwaitData) {
            n2 += 32;
        }
        if (this.myExhaust) {
            n2 += 64;
        }
        if (this.myNoCursorTimeout) {
            n2 += 16;
        }
        if (this.myPartial) {
            n2 += 128;
        }
        if (this.getReadPreference().isSecondaryOk()) {
            n2 += 4;
        }
        if (this.myTailable) {
            n2 += 2;
        }
        int n3 = 16;
        n3 += 4;
        n3 += bsonOutputStream.sizeOfCString(this.myDatabaseName, ".", this.myCollectionName);
        n3 += 4;
        n3 += 4;
        n3 += bsonOutputStream.sizeOf(this.myQuery);
        if (this.myReturnFields != null) {
            n3 += bsonOutputStream.sizeOf(this.myReturnFields);
        }
        this.writeHeader(bsonOutputStream, n, 0, Operation.QUERY, n3);
        bsonOutputStream.writeInt(n2);
        bsonOutputStream.writeCString(this.myDatabaseName, ".", this.myCollectionName);
        bsonOutputStream.writeInt(this.myNumberToSkip);
        bsonOutputStream.writeInt(this.myNumberToReturn);
        bsonOutputStream.writeDocument(this.myQuery);
        if (this.myReturnFields != null) {
            bsonOutputStream.writeDocument(this.myReturnFields);
        }
    }
}

