/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.message;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.connection.FutureCallback;
import com.allanbank.mongodb.connection.message.Reply;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

public class ReplyHandler
implements Runnable {
    private final Throwable myError;
    private final Reply myReply;
    private final Callback<Reply> myReplyCallback;

    public static void raiseError(Throwable throwable, Callback<Reply> callback, Executor executor) {
        if (callback != null) {
            if (executor != null) {
                try {
                    executor.execute(new ReplyHandler(callback, throwable));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    callback.exception(throwable);
                }
            } else {
                callback.exception(throwable);
            }
        }
    }

    public static void reply(Reply reply, Callback<Reply> callback, Executor executor) {
        if (callback != null) {
            if (FutureCallback.CLASS != callback.getClass() && executor != null) {
                try {
                    executor.execute(new ReplyHandler(callback, reply));
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                    callback.callback(reply);
                }
            } else {
                callback.callback(reply);
            }
        }
    }

    public ReplyHandler(Callback<Reply> callback, Reply reply) {
        this.myReplyCallback = callback;
        this.myReply = reply;
        this.myError = null;
    }

    public ReplyHandler(Callback<Reply> callback, Throwable throwable) {
        this.myReplyCallback = callback;
        this.myError = throwable;
        this.myReply = null;
    }

    @Override
    public void run() {
        if (this.myReply != null) {
            ReplyHandler.reply(this.myReply, this.myReplyCallback, null);
        } else if (this.myError != null) {
            ReplyHandler.raiseError(this.myError, this.myReplyCallback, null);
        }
    }
}

