/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.message;

import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.io.BsonInputStream;
import com.allanbank.mongodb.bson.io.BsonOutputStream;
import com.allanbank.mongodb.bson.io.SizeOfVisitor;
import com.allanbank.mongodb.connection.Operation;
import com.allanbank.mongodb.connection.message.AbstractMessage;
import com.allanbank.mongodb.error.DocumentToLargeException;
import java.io.IOException;

public class Update
extends AbstractMessage {
    public static final int MULTIUPDATE_FLAG_BIT = 2;
    public static final int UPSERT_FLAG_BIT = 1;
    private int myMessageSize;
    private final boolean myMultiUpdate;
    private final Document myQuery;
    private final Document myUpdate;
    private final boolean myUpsert;

    public Update(BsonInputStream bsonInputStream) throws IOException {
        bsonInputStream.readInt();
        this.init(bsonInputStream.readCString());
        int n = bsonInputStream.readInt();
        this.myQuery = bsonInputStream.readDocument();
        this.myUpdate = bsonInputStream.readDocument();
        this.myUpsert = (n & 1) == 1;
        this.myMultiUpdate = (n & 2) == 2;
        this.myMessageSize = -1;
    }

    public Update(String string, String string2, Document document, Document document2, boolean bl, boolean bl2) {
        super(string, string2, ReadPreference.PRIMARY);
        this.myQuery = document;
        this.myUpdate = document2;
        this.myMultiUpdate = bl;
        this.myUpsert = bl2;
        this.myMessageSize = -1;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object != null && this.getClass() == object.getClass()) {
            Update update = (Update)object;
            bl = super.equals(object) && this.myMultiUpdate == update.myMultiUpdate && this.myUpsert == update.myUpsert && this.myUpdate.equals(update.myUpdate) && this.myQuery.equals(update.myQuery);
        }
        return bl;
    }

    public Document getQuery() {
        return this.myQuery;
    }

    public Document getUpdate() {
        return this.myUpdate;
    }

    @Override
    public int hashCode() {
        int n = 1;
        n = 31 * n + super.hashCode();
        n = 31 * n + (this.myMultiUpdate ? 1 : 3);
        n = 31 * n + (this.myUpsert ? 1 : 3);
        n = 31 * n + this.myUpdate.hashCode();
        n = 31 * n + this.myQuery.hashCode();
        return n;
    }

    public boolean isMultiUpdate() {
        return this.myMultiUpdate;
    }

    public boolean isUpsert() {
        return this.myUpsert;
    }

    @Override
    public void validateSize(SizeOfVisitor sizeOfVisitor, int n) throws DocumentToLargeException {
        if (this.myMessageSize < 0) {
            sizeOfVisitor.reset();
            if (this.myQuery != null) {
                this.myQuery.accept(sizeOfVisitor);
            }
            if (this.myUpdate != null) {
                this.myUpdate.accept(sizeOfVisitor);
            }
            this.myMessageSize = sizeOfVisitor.getSize();
        }
        if (n < this.myMessageSize) {
            throw new DocumentToLargeException(this.myMessageSize, n, this.myUpdate);
        }
    }

    @Override
    public void write(int n, BsonOutputStream bsonOutputStream) throws IOException {
        int n2 = 0;
        if (this.myMultiUpdate) {
            n2 += 2;
        }
        if (this.myUpsert) {
            ++n2;
        }
        int n3 = 16;
        n3 += 4;
        n3 += bsonOutputStream.sizeOfCString(this.myDatabaseName, ".", this.myCollectionName);
        n3 += 4;
        n3 += bsonOutputStream.sizeOf(this.myQuery);
        this.writeHeader(bsonOutputStream, n, 0, Operation.UPDATE, n3 += bsonOutputStream.sizeOf(this.myUpdate));
        bsonOutputStream.writeInt(0);
        bsonOutputStream.writeCString(this.myDatabaseName, ".", this.myCollectionName);
        bsonOutputStream.writeInt(n2);
        bsonOutputStream.writeDocument(this.myQuery);
        bsonOutputStream.writeDocument(this.myUpdate);
    }
}

