/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.proxy;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.Message;
import com.allanbank.mongodb.connection.message.PendingMessage;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.util.IOUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public abstract class AbstractProxyConnection
implements Connection {
    protected final MongoClientConfiguration myConfig;
    private final Connection myProxiedConnection;

    public AbstractProxyConnection(Connection connection, MongoClientConfiguration mongoClientConfiguration) {
        this.myProxiedConnection = connection;
        this.myConfig = mongoClientConfiguration;
    }

    @Override
    public void addPending(List<PendingMessage> list) throws InterruptedException {
        try {
            this.myProxiedConnection.addPending(list);
        }
        catch (MongoDbException mongoDbException) {
            this.onExceptin(mongoDbException);
            throw mongoDbException;
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        try {
            this.myProxiedConnection.addPropertyChangeListener(new ProxiedChangeListener(this, propertyChangeListener));
        }
        catch (MongoDbException mongoDbException) {
            this.onExceptin(mongoDbException);
            propertyChangeListener.propertyChange(new PropertyChangeEvent(this, "open", Boolean.TRUE, Boolean.FALSE));
        }
    }

    @Override
    public void close() throws IOException {
        this.myProxiedConnection.close();
    }

    @Override
    public void drainPending(List<PendingMessage> list) {
        try {
            this.myProxiedConnection.drainPending(list);
        }
        catch (MongoDbException mongoDbException) {
            this.onExceptin(mongoDbException);
            throw mongoDbException;
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            this.myProxiedConnection.flush();
        }
        catch (MongoDbException mongoDbException) {
            this.onExceptin(mongoDbException);
            throw mongoDbException;
        }
    }

    @Override
    public int getPendingCount() {
        try {
            return this.myProxiedConnection.getPendingCount();
        }
        catch (MongoDbException mongoDbException) {
            this.onExceptin(mongoDbException);
            throw mongoDbException;
        }
    }

    @Override
    public String getServerName() {
        return this.getProxiedConnection().getServerName();
    }

    @Override
    public boolean isIdle() {
        try {
            return this.myProxiedConnection.isIdle();
        }
        catch (MongoDbException mongoDbException) {
            this.onExceptin(mongoDbException);
            throw mongoDbException;
        }
    }

    @Override
    public boolean isOpen() {
        try {
            return this.myProxiedConnection.isOpen();
        }
        catch (MongoDbException mongoDbException) {
            this.onExceptin(mongoDbException);
            throw mongoDbException;
        }
    }

    @Override
    public void raiseErrors(MongoDbException mongoDbException, boolean bl) {
        this.myProxiedConnection.raiseErrors(mongoDbException, bl);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.myProxiedConnection.removePropertyChangeListener(new ProxiedChangeListener(this, propertyChangeListener));
    }

    @Override
    public String send(Message message, Callback<Reply> callback) throws MongoDbException {
        try {
            return this.myProxiedConnection.send(message, callback);
        }
        catch (MongoDbException mongoDbException) {
            this.onExceptin(mongoDbException);
            throw mongoDbException;
        }
    }

    @Override
    public String send(Message message, Message message2, Callback<Reply> callback) throws MongoDbException {
        try {
            return this.myProxiedConnection.send(message, message2, callback);
        }
        catch (MongoDbException mongoDbException) {
            this.onExceptin(mongoDbException);
            throw mongoDbException;
        }
    }

    @Override
    public void shutdown() {
        this.myProxiedConnection.shutdown();
    }

    @Override
    public void waitForClosed(int n, TimeUnit timeUnit) {
        try {
            this.myProxiedConnection.waitForClosed(n, timeUnit);
        }
        catch (MongoDbException mongoDbException) {
            this.onExceptin(mongoDbException);
            throw mongoDbException;
        }
    }

    protected Connection getProxiedConnection() {
        return this.myProxiedConnection;
    }

    protected void onExceptin(MongoDbException mongoDbException) {
        IOUtils.close(this);
    }

    protected static class ProxiedChangeListener
    implements PropertyChangeListener {
        private final PropertyChangeListener myDelegate;
        private final AbstractProxyConnection myProxiedConn;

        public ProxiedChangeListener(AbstractProxyConnection abstractProxyConnection, PropertyChangeListener propertyChangeListener) {
            this.myProxiedConn = abstractProxyConnection;
            this.myDelegate = propertyChangeListener;
        }

        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                bl = true;
            } else if (object != null && this.getClass() == object.getClass()) {
                ProxiedChangeListener proxiedChangeListener = (ProxiedChangeListener)object;
                bl = this.myDelegate.equals(proxiedChangeListener.myDelegate);
            }
            return bl;
        }

        public int hashCode() {
            return this.myDelegate == null ? 13 : this.myDelegate.hashCode();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(this.myProxiedConn, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
            propertyChangeEvent2.setPropagationId(propertyChangeEvent.getPropagationId());
            this.myDelegate.propertyChange(propertyChangeEvent2);
        }
    }
}

