/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.rs;

import com.allanbank.mongodb.Callback;
import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.Message;
import com.allanbank.mongodb.connection.ReconnectStrategy;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.connection.proxy.AbstractProxyConnection;
import com.allanbank.mongodb.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.connection.state.ClusterState;
import com.allanbank.mongodb.connection.state.ServerState;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;

public class ReplicaSetConnection
extends AbstractProxyConnection {
    protected static final Logger LOG = Logger.getLogger(ReplicaSetConnection.class.getCanonicalName());
    private final ClusterState myCluster;
    private final ProxiedConnectionFactory myFactory;
    private final ServerState myPrimaryServer;

    public ReplicaSetConnection(Connection connection, ServerState serverState, ClusterState clusterState, ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        super(connection, mongoClientConfiguration);
        this.myPrimaryServer = serverState;
        this.myCluster = clusterState;
        this.myFactory = proxiedConnectionFactory;
    }

    @Override
    public String send(Message message, Callback<Reply> callback) throws MongoDbException {
        return this.send(message, null, callback);
    }

    @Override
    public String send(Message message, Message message2, Callback<Reply> callback) throws MongoDbException {
        List<ServerState> list = this.findPotentialServers(message, message2);
        String string = this.trySendToOpenConnection(list, message, message2, callback);
        if (string == null) {
            string = this.trySend(list, message, message2, callback);
        }
        if (string == null) {
            throw new MongoDbException("Could not send the messages to any of the potential servers.");
        }
        return string;
    }

    public String toString() {
        return "ReplicaSet(" + this.getProxiedConnection() + ")";
    }

    protected String doSend(Connection connection, Message message, Message message2, Callback<Reply> callback) {
        if (message2 == null) {
            return connection.send(message, callback);
        }
        return connection.send(message, message2, callback);
    }

    protected List<ServerState> findPotentialServers(Message message, Message message2) throws MongoDbException {
        List<ServerState> list;
        if (message != null) {
            List<ServerState> list2 = this.myCluster.findCandidateServers(message.getReadPreference());
            list = list2;
            if (message2 != null) {
                list = new ArrayList<ServerState>(list2);
                list2 = this.myCluster.findCandidateServers(message2.getReadPreference());
                list.retainAll(list2);
            }
            if (list.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Could not find any servers for the following set of read preferences: ");
                HashSet<ReadPreference> hashSet = new HashSet<ReadPreference>();
                for (Message message3 : Arrays.asList(message, message2)) {
                    ReadPreference readPreference;
                    if (message3 == null || !hashSet.add(readPreference = message3.getReadPreference())) continue;
                    if (hashSet.size() == 1) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(readPreference);
                }
                stringBuilder.append('.');
                throw new MongoDbException(stringBuilder.toString());
            }
        } else {
            list = Collections.singletonList(this.myPrimaryServer);
        }
        return list;
    }

    protected Connection reconnect(Connection connection) {
        ReconnectStrategy reconnectStrategy = this.myFactory.getReconnectStrategy();
        Connection connection2 = reconnectStrategy.reconnect(connection);
        IOUtils.close(connection);
        return connection2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String trySend(List<ServerState> list, Message message, Message message2, Callback<Reply> callback) {
        for (ServerState serverState : list) {
            Connection connection = null;
            try {
                Object object;
                connection = serverState.takeConnection();
                if (connection == null) {
                    try {
                        connection = this.myFactory.connect(serverState, this.myConfig);
                    }
                    catch (IOException iOException) {
                        LOG.info("Could not connect to the server '" + serverState.getName() + "': " + iOException.getMessage());
                    }
                } else if (!connection.isOpen()) {
                    object = this.reconnect(connection);
                    connection = object;
                }
                if (connection == null) continue;
                object = this.doSend(connection, message, message2, callback);
                return object;
            }
            finally {
                if (connection == null || serverState.addConnection(connection)) continue;
                connection.shutdown();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String trySendToOpenConnection(List<ServerState> list, Message message, Message message2, Callback<Reply> callback) {
        for (ServerState serverState : list) {
            if (serverState.equals(this.myPrimaryServer)) {
                if (message2 == null) {
                    return super.send(message, callback);
                }
                return super.send(message, message2, callback);
            }
            Connection connection = null;
            try {
                connection = serverState.takeConnection();
                if (connection != null && !connection.isOpen()) {
                    connection = this.reconnect(connection);
                }
                if (connection == null) continue;
                String string = this.doSend(connection, message, message2, callback);
                return string;
            }
            finally {
                if (connection == null || serverState.addConnection(connection)) continue;
                connection.shutdown();
            }
        }
        return null;
    }
}

