/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.rs;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.connection.ClusterType;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.ConnectionFactory;
import com.allanbank.mongodb.connection.FutureCallback;
import com.allanbank.mongodb.connection.ReconnectStrategy;
import com.allanbank.mongodb.connection.message.IsMaster;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.connection.rs.ReplicaSetConnection;
import com.allanbank.mongodb.connection.rs.ReplicaSetReconnectStrategy;
import com.allanbank.mongodb.connection.state.ClusterPinger;
import com.allanbank.mongodb.connection.state.ClusterState;
import com.allanbank.mongodb.connection.state.LatencyServerSelector;
import com.allanbank.mongodb.connection.state.ServerState;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicaSetConnectionFactory
implements ConnectionFactory {
    protected static final Logger LOG = Logger.getLogger(ReplicaSetConnectionFactory.class.getCanonicalName());
    protected final ProxiedConnectionFactory myConnectionFactory;
    private final ClusterState myClusterState;
    private final MongoClientConfiguration myConfig;
    private final ClusterPinger myPinger;

    public ReplicaSetConnectionFactory(ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        this.myConnectionFactory = proxiedConnectionFactory;
        this.myConfig = mongoClientConfiguration;
        this.myClusterState = new ClusterState(mongoClientConfiguration);
        this.myPinger = new ClusterPinger(this.myClusterState, ClusterType.REPLICA_SET, proxiedConnectionFactory, mongoClientConfiguration);
        for (String string : mongoClientConfiguration.getServers()) {
            ServerState serverState = this.myClusterState.add(string);
            this.myClusterState.markNotWritable(serverState);
        }
        this.bootstrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        for (InetSocketAddress inetSocketAddress : this.myConfig.getServerAddresses()) {
            Connection connection = null;
            FutureCallback<Reply> futureCallback = new FutureCallback<Reply>();
            try {
                Object object;
                Object object2;
                connection = this.myConnectionFactory.connect(new ServerState(inetSocketAddress), this.myConfig);
                connection.send(new IsMaster(), futureCallback);
                Reply reply = futureCallback.get();
                List<Document> list = reply.getResults();
                if (list.isEmpty()) continue;
                Document document = list.get(0);
                if (this.myConfig.isAutoDiscoverServers()) {
                    object2 = document.find(StringElement.class, "hosts", ".*");
                    object = object2.iterator();
                    while (object.hasNext()) {
                        StringElement stringElement = (StringElement)object.next();
                        this.myClusterState.add(stringElement.getValue());
                    }
                }
                if (!(object2 = document.find(StringElement.class, "primary").iterator()).hasNext()) continue;
                object = (StringElement)object2.next();
                this.myClusterState.markWritable(this.myClusterState.get(((StringElement)object).getValue()));
            }
            catch (IOException iOException) {
                LOG.log(Level.WARNING, "I/O error during replica-set bootstrap to " + inetSocketAddress + ".", iOException);
            }
            catch (MongoDbException mongoDbException) {
                LOG.log(Level.WARNING, "MongoDB error during replica-set bootstrap to " + inetSocketAddress + ".", mongoDbException);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.WARNING, "Interrupted during replica-set bootstrap to " + inetSocketAddress + ".", interruptedException);
            }
            catch (ExecutionException executionException) {
                LOG.log(Level.WARNING, "Error during replica-set bootstrap to " + inetSocketAddress + ".", executionException);
            }
            finally {
                IOUtils.close(connection, Level.WARNING, "I/O error shutting down replica-set bootstrap connection to " + inetSocketAddress + ".");
            }
        }
        this.myPinger.initialSweep();
        this.myPinger.start();
    }

    @Override
    public void close() {
        IOUtils.close(this.myPinger);
        IOUtils.close(this.myClusterState);
        IOUtils.close(this.myConnectionFactory);
    }

    @Override
    public Connection connect() throws IOException {
        IOException iOException = null;
        for (ServerState serverState : this.myClusterState.getWritableServers()) {
            try {
                Connection connection = this.myConnectionFactory.connect(serverState, this.myConfig);
                return new ReplicaSetConnection(connection, serverState, this.myClusterState, this.myConnectionFactory, this.myConfig);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        throw new IOException("Could not determine the primary server in the replica set.");
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.REPLICA_SET;
    }

    @Override
    public ReconnectStrategy getReconnectStrategy() {
        ReplicaSetReconnectStrategy replicaSetReconnectStrategy = new ReplicaSetReconnectStrategy();
        replicaSetReconnectStrategy.setConfig(this.myConfig);
        replicaSetReconnectStrategy.setConnectionFactory(this.myConnectionFactory);
        replicaSetReconnectStrategy.setState(this.myClusterState);
        replicaSetReconnectStrategy.setSelector(new LatencyServerSelector(this.myClusterState, false));
        return replicaSetReconnectStrategy;
    }

    protected ClusterState getClusterState() {
        return this.myClusterState;
    }
}

