/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.rs;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.FutureCallback;
import com.allanbank.mongodb.connection.message.IsMaster;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.connection.rs.ReplicaSetConnection;
import com.allanbank.mongodb.connection.state.AbstractReconnectStrategy;
import com.allanbank.mongodb.connection.state.ClusterState;
import com.allanbank.mongodb.connection.state.ServerState;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReplicaSetReconnectStrategy
extends AbstractReconnectStrategy {
    public static final int INITIAL_RECONNECT_PAUSE_TIME_MS = 100;
    public static final int MAX_RECONNECT_PAUSE_TIME_MS = 5000;
    protected static final Logger LOG = Logger.getLogger(ReplicaSetReconnectStrategy.class.getCanonicalName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaSetConnection reconnect(Connection connection) {
        LOG.fine("Trying replica set reconnect.");
        ClusterState clusterState = this.getState();
        HashMap<InetSocketAddress, Future<Reply>> hashMap = new HashMap<InetSocketAddress, Future<Reply>>();
        HashMap<InetSocketAddress, Connection> hashMap2 = new HashMap<InetSocketAddress, Connection>();
        try {
            int n = this.getConfig().getReconnectTimeout();
            long l = System.currentTimeMillis();
            long l2 = n <= 0 ? Long.MAX_VALUE : l + (long)n;
            int n2 = 100;
            while (l < l2) {
                for (ServerState object : clusterState.getServers()) {
                    this.sendIsPrimary(hashMap, hashMap2, object, false);
                    ReplicaSetConnection replicaSetConnection = this.checkForReply(connection, hashMap, hashMap2);
                    if (replicaSetConnection == null) continue;
                    ReplicaSetConnection replicaSetConnection2 = replicaSetConnection;
                    return replicaSetConnection2;
                }
                this.sleep(n2, TimeUnit.MILLISECONDS);
                n2 = Math.min(5000, n2 + n2);
                ReplicaSetConnection replicaSetConnection = this.checkForReply(connection, hashMap, hashMap2);
                if (replicaSetConnection != null) {
                    ReplicaSetConnection replicaSetConnection3 = replicaSetConnection;
                    return replicaSetConnection3;
                }
                l = System.currentTimeMillis();
            }
        }
        finally {
            for (Connection connection2 : hashMap2.values()) {
                IOUtils.close(connection2);
            }
        }
        return null;
    }

    protected ReplicaSetConnection checkForReply(Connection connection, Map<InetSocketAddress, Future<Reply>> map, Map<InetSocketAddress, Connection> map2) {
        HashMap<InetSocketAddress, Future<Reply>> hashMap = new HashMap<InetSocketAddress, Future<Reply>>(map);
        for (Map.Entry entry : hashMap.entrySet()) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)entry.getKey();
            Future future = (Future)entry.getValue();
            if (future.isDone()) {
                map.remove(inetSocketAddress);
                String string = this.checkReply(future, map2, inetSocketAddress);
                if (string == null || !this.verifyPutative(map, map2, string)) continue;
                ServerState serverState = this.getState().get(string);
                for (ServerState object2 : this.getState().getWritableServers()) {
                    this.getState().markNotWritable(object2);
                }
                this.getState().markWritable(serverState);
                Connection connection2 = map2.remove(serverState.getServer());
                ReplicaSetConnection replicaSetConnection = new ReplicaSetConnection(connection2, serverState, this.getState(), this.getConnectionFactory(), this.getConfig());
                this.copyPending(replicaSetConnection, connection);
                return replicaSetConnection;
            }
            LOG.fine("No reply yet from " + inetSocketAddress);
        }
        return null;
    }

    protected String checkReply(Future<Reply> future, Map<InetSocketAddress, Connection> map, InetSocketAddress inetSocketAddress) {
        if (future != null) {
            try {
                Document document;
                Element element;
                Reply reply = future.get();
                List<Document> list = reply.getResults();
                if (!list.isEmpty() && (element = (document = list.get(0)).get("primary")) instanceof StringElement) {
                    return ((StringElement)element).getValue();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                Connection connection = map.remove(inetSocketAddress);
                IOUtils.close(connection);
            }
        }
        return null;
    }

    protected Future<Reply> sendIsPrimary(Map<InetSocketAddress, Future<Reply>> map, Map<InetSocketAddress, Connection> map2, ServerState serverState, boolean bl) {
        Future<Reply> future = null;
        InetSocketAddress inetSocketAddress = serverState.getServer();
        try {
            Connection connection = map2.get(inetSocketAddress);
            if (connection == null || !connection.isOpen()) {
                connection = this.getConnectionFactory().connect(serverState, this.getConfig());
                map2.put(inetSocketAddress, connection);
            }
            if ((future = map.get(inetSocketAddress)) == null) {
                LOG.fine("Sending reconnect(rs) query to " + serverState.getServer());
                FutureCallback<Reply> futureCallback = new FutureCallback<Reply>();
                connection.send(new IsMaster(), futureCallback);
                future = futureCallback;
                map.put(inetSocketAddress, future);
            }
        }
        catch (IOException iOException) {
            Level level = bl ? Level.WARNING : Level.FINE;
            LOG.log(level, "Cannot create a connection to '" + inetSocketAddress + "'.", iOException);
        }
        return future;
    }

    protected void sleep(int n, TimeUnit timeUnit) {
        try {
            timeUnit.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected boolean verifyPutative(Map<InetSocketAddress, Future<Reply>> map, Map<InetSocketAddress, Connection> map2, String string) {
        LOG.fine("Verify putative server (" + string + ") on reconnect(rs).");
        ServerState serverState = this.getState().get(string);
        map.remove(serverState.getServer());
        Future<Reply> future = this.sendIsPrimary(map, map2, serverState, true);
        String string2 = this.checkReply(future, map2, serverState.getServer());
        if (string.equals(string2)) {
            LOG.info("New primary for replica set: " + string);
            return true;
        }
        return false;
    }
}

