/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.sharded;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.connection.ClusterType;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.ConnectionFactory;
import com.allanbank.mongodb.connection.FutureCallback;
import com.allanbank.mongodb.connection.ReconnectStrategy;
import com.allanbank.mongodb.connection.message.Query;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.connection.sharded.ShardedConnection;
import com.allanbank.mongodb.connection.state.ClusterPinger;
import com.allanbank.mongodb.connection.state.ClusterState;
import com.allanbank.mongodb.connection.state.LatencyServerSelector;
import com.allanbank.mongodb.connection.state.ServerSelector;
import com.allanbank.mongodb.connection.state.ServerState;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShardedConnectionFactory
implements ConnectionFactory {
    protected static final Logger LOG = Logger.getLogger(ShardedConnectionFactory.class.getCanonicalName());
    protected final ProxiedConnectionFactory myConnectionFactory;
    private final ClusterState myClusterState;
    private final MongoClientConfiguration myConfig;
    private final ClusterPinger myPinger;
    private final ServerSelector mySelector;

    public ShardedConnectionFactory(ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        this.myConnectionFactory = proxiedConnectionFactory;
        this.myConfig = mongoClientConfiguration;
        this.myClusterState = new ClusterState(mongoClientConfiguration);
        this.mySelector = new LatencyServerSelector(this.myClusterState, true);
        this.myPinger = new ClusterPinger(this.myClusterState, ClusterType.SHARDED, proxiedConnectionFactory, mongoClientConfiguration);
        for (String string : mongoClientConfiguration.getServers()) {
            ServerState serverState = this.myClusterState.add(string);
            this.myClusterState.markWritable(serverState);
        }
        this.bootstrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bootstrap() {
        if (this.myConfig.isAutoDiscoverServers()) {
            Query query = new Query("config", "mongos", BuilderFactory.start().build(), null, 0, 0, 0, false, ReadPreference.PRIMARY, false, false, false, false);
            for (String string : this.myConfig.getServers()) {
                Connection connection = null;
                FutureCallback<Reply> futureCallback = new FutureCallback<Reply>();
                try {
                    connection = this.myConnectionFactory.connect(this.myClusterState.add(string), this.myConfig);
                    connection.send(query, futureCallback);
                    Reply reply = futureCallback.get();
                    List<Document> list = reply.getResults();
                    for (Document document : list) {
                        Element element = document.get("_id");
                        if (!(element instanceof StringElement)) continue;
                        StringElement stringElement = (StringElement)element;
                        this.myClusterState.markWritable(this.myClusterState.add(stringElement.getValue()));
                        LOG.fine("Adding shard mongos: " + stringElement.getValue());
                    }
                }
                catch (IOException iOException) {
                    LOG.log(Level.WARNING, "I/O error during sharded bootstrap to " + string + ".", iOException);
                }
                catch (MongoDbException mongoDbException) {
                    LOG.log(Level.WARNING, "MongoDB error during sharded bootstrap to " + string + ".", mongoDbException);
                }
                catch (InterruptedException interruptedException) {
                    LOG.log(Level.WARNING, "Interrupted during sharded bootstrap to " + string + ".", interruptedException);
                }
                catch (ExecutionException executionException) {
                    LOG.log(Level.WARNING, "Error during sharded bootstrap to " + string + ".", executionException);
                }
                finally {
                    IOUtils.close(connection, Level.WARNING, "I/O error shutting down sharded bootstrap connection to " + string + ".");
                }
            }
        }
        this.myPinger.initialSweep();
        this.myPinger.start();
    }

    @Override
    public void close() {
        IOUtils.close(this.myPinger);
        IOUtils.close(this.myClusterState);
        IOUtils.close(this.myConnectionFactory);
    }

    @Override
    public Connection connect() throws IOException {
        IOException iOException = null;
        for (ServerState serverState : this.myClusterState.getWritableServers()) {
            try {
                Connection connection = this.myConnectionFactory.connect(serverState, this.myConfig);
                return new ShardedConnection(connection, this.myConfig);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        throw new IOException("Could not determine a shard server to connect to.");
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.SHARDED;
    }

    @Override
    public ReconnectStrategy getReconnectStrategy() {
        ReconnectStrategy reconnectStrategy = this.myConnectionFactory.getReconnectStrategy();
        reconnectStrategy.setState(this.myClusterState);
        reconnectStrategy.setSelector(this.mySelector);
        reconnectStrategy.setConnectionFactory(this.myConnectionFactory);
        return reconnectStrategy;
    }

    protected ClusterState getClusterState() {
        return this.myClusterState;
    }
}

