/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.socket;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.connection.ClusterType;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.ReconnectStrategy;
import com.allanbank.mongodb.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.connection.socket.SocketConnection;
import com.allanbank.mongodb.connection.state.ClusterState;
import com.allanbank.mongodb.connection.state.LatencyServerSelector;
import com.allanbank.mongodb.connection.state.ServerSelector;
import com.allanbank.mongodb.connection.state.ServerState;
import com.allanbank.mongodb.connection.state.SimpleReconnectStrategy;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;

public class SocketConnectionFactory
implements ProxiedConnectionFactory {
    private final MongoClientConfiguration myConfig;
    private final ServerSelector myServerSelector;
    private final ClusterState myState;

    public SocketConnectionFactory(MongoClientConfiguration mongoClientConfiguration) {
        this.myConfig = mongoClientConfiguration;
        this.myState = new ClusterState(mongoClientConfiguration);
        this.myServerSelector = new LatencyServerSelector(this.myState, true);
        for (String string : mongoClientConfiguration.getServers()) {
            ServerState serverState = this.myState.add(string);
            this.myState.markWritable(serverState);
        }
    }

    @Override
    public void close() {
        IOUtils.close(this.myState);
    }

    @Override
    public Connection connect() throws IOException {
        ArrayList<InetSocketAddress> arrayList = new ArrayList<InetSocketAddress>(this.myConfig.getServerAddresses());
        IOException iOException = null;
        Collections.shuffle(arrayList);
        for (InetSocketAddress inetSocketAddress : arrayList) {
            try {
                return this.connect(new ServerState(inetSocketAddress), this.myConfig);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        throw new IOException("Could not connect to any server: " + arrayList);
    }

    @Override
    public Connection connect(ServerState serverState, MongoClientConfiguration mongoClientConfiguration) throws IOException {
        SocketConnection socketConnection = new SocketConnection(serverState, this.myConfig);
        socketConnection.start();
        return socketConnection;
    }

    @Override
    public ClusterType getClusterType() {
        return ClusterType.STAND_ALONE;
    }

    @Override
    public ReconnectStrategy getReconnectStrategy() {
        SimpleReconnectStrategy simpleReconnectStrategy = new SimpleReconnectStrategy();
        simpleReconnectStrategy.setConfig(this.myConfig);
        simpleReconnectStrategy.setConnectionFactory(this);
        simpleReconnectStrategy.setSelector(this.myServerSelector);
        simpleReconnectStrategy.setState(this.myState);
        return simpleReconnectStrategy;
    }
}

