/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.state;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.ReconnectStrategy;
import com.allanbank.mongodb.connection.message.PendingMessage;
import com.allanbank.mongodb.connection.message.ReplyHandler;
import com.allanbank.mongodb.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.connection.state.ClusterPinger;
import com.allanbank.mongodb.connection.state.ClusterState;
import com.allanbank.mongodb.connection.state.ServerSelector;
import com.allanbank.mongodb.connection.state.ServerState;
import java.util.ArrayList;
import java.util.concurrent.Executor;

public abstract class AbstractReconnectStrategy
implements ReconnectStrategy {
    protected MongoClientConfiguration myConfig = null;
    protected ProxiedConnectionFactory myConnectionFactory = null;
    protected ServerSelector mySelector = null;
    protected ClusterState myState = null;

    public MongoClientConfiguration getConfig() {
        return this.myConfig;
    }

    public ProxiedConnectionFactory getConnectionFactory() {
        return this.myConnectionFactory;
    }

    public ServerSelector getSelector() {
        return this.mySelector;
    }

    public ClusterState getState() {
        return this.myState;
    }

    @Override
    public void setConfig(MongoClientConfiguration mongoClientConfiguration) {
        this.myConfig = mongoClientConfiguration;
    }

    @Override
    public void setConnectionFactory(ProxiedConnectionFactory proxiedConnectionFactory) {
        this.myConnectionFactory = proxiedConnectionFactory;
    }

    @Override
    public void setSelector(ServerSelector serverSelector) {
        this.mySelector = serverSelector;
    }

    @Override
    public void setState(ClusterState clusterState) {
        this.myState = clusterState;
    }

    protected void copyPending(Connection connection, Connection connection2) {
        ArrayList<PendingMessage> arrayList = new ArrayList<PendingMessage>();
        connection2.drainPending(arrayList);
        try {
            connection.addPending(arrayList);
        }
        catch (InterruptedException interruptedException) {
            Executor executor = this.myConfig.getExecutor();
            MongoDbException mongoDbException = new MongoDbException(interruptedException);
            for (PendingMessage pendingMessage : arrayList) {
                ReplyHandler.raiseError(mongoDbException, pendingMessage.getReplyCallback(), executor);
            }
        }
    }

    protected boolean isConnected(ServerState serverState, Connection connection) {
        return ClusterPinger.ping(serverState.getServer(), connection);
    }
}

