/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.state;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.connection.ClusterType;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.message.IsMaster;
import com.allanbank.mongodb.connection.message.ReplicaSetStatus;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.connection.proxy.ProxiedConnectionFactory;
import com.allanbank.mongodb.connection.state.ClusterState;
import com.allanbank.mongodb.connection.state.SecondsBehindCallback;
import com.allanbank.mongodb.connection.state.ServerLatencyCallback;
import com.allanbank.mongodb.connection.state.ServerState;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClusterPinger
implements Runnable,
Closeable {
    public static final int DEFAULT_PING_INTERVAL_SECONDS = 600;
    protected static final Logger LOG = Logger.getLogger(ClusterPinger.class.getCanonicalName());
    private static final Pinger PINGER = new Pinger();
    private final ClusterState myCluster;
    private final ClusterType myClusterType;
    private final MongoClientConfiguration myConfig;
    private final ProxiedConnectionFactory myConnectionFactory;
    private volatile TimeUnit myIntervalUnits = TimeUnit.SECONDS;
    private volatile int myPingSweepInterval = 600;
    private final Thread myPingThread;
    private volatile boolean myRunning;

    public static boolean ping(InetSocketAddress inetSocketAddress, Connection connection) {
        return PINGER.ping(inetSocketAddress, connection, null);
    }

    public ClusterPinger(ClusterState clusterState, ClusterType clusterType, ProxiedConnectionFactory proxiedConnectionFactory, MongoClientConfiguration mongoClientConfiguration) {
        this.myCluster = clusterState;
        this.myClusterType = clusterType;
        this.myConnectionFactory = proxiedConnectionFactory;
        this.myConfig = mongoClientConfiguration;
        this.myRunning = true;
        this.myPingThread = this.myConfig.getThreadFactory().newThread(this);
        this.myPingThread.setDaemon(true);
        this.myPingThread.setName("MongoDB Pinger");
        this.myPingThread.setPriority(1);
    }

    @Override
    public void close() {
        this.myRunning = false;
        this.myPingThread.interrupt();
    }

    public TimeUnit getIntervalUnits() {
        return this.myIntervalUnits;
    }

    public int getPingSweepInterval() {
        return this.myPingSweepInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialSweep() {
        Object object;
        List<ServerState> list = this.myCluster.getServers();
        ArrayList<Future<Reply>> arrayList = new ArrayList<Future<Reply>>(list.size());
        for (ServerState object2 : list) {
            object = object2.getName();
            Connection timeoutException = null;
            try {
                timeoutException = object2.takeConnection();
                if (timeoutException == null) {
                    timeoutException = this.myConnectionFactory.connect(object2, this.myConfig);
                }
                Future<Reply> future = PINGER.pingAsync(this.myClusterType, object2.getServer(), timeoutException, object2);
                arrayList.add(future);
                if (!object2.addConnection(timeoutException)) continue;
                timeoutException = null;
            }
            catch (IOException iOException) {
                LOG.info("Could not ping '" + (String)object + "': " + iOException.getMessage());
            }
            finally {
                if (timeoutException == null) continue;
                timeoutException.shutdown();
            }
        }
        int n = Math.max(1, arrayList.size() / 2);
        while (n <= arrayList.size()) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                object = (Future)iterator.next();
                try {
                    if (object != null) {
                        object.get(10L, TimeUnit.MILLISECONDS);
                    }
                    iterator.remove();
                }
                catch (ExecutionException interruptedException) {
                    iterator.remove();
                }
                catch (TimeoutException timeoutException) {
                    object = null;
                }
                catch (InterruptedException interruptedException) {
                    object = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.myRunning) {
            try {
                List<ServerState> list = this.myCluster.getServers();
                long l = this.getIntervalUnits().toMillis(this.getPingSweepInterval());
                long l2 = list.isEmpty() ? l : l / (long)list.size();
                Thread.sleep(TimeUnit.MILLISECONDS.toMillis(l2));
                for (ServerState serverState : list) {
                    String string = serverState.getName();
                    Connection connection = null;
                    try {
                        Connection connection2;
                        this.myPingThread.setName("MongoDB Pinger - " + string);
                        connection = serverState.takeConnection();
                        if (connection == null) {
                            connection = this.myConnectionFactory.connect(serverState, this.myConfig);
                        }
                        PINGER.pingAsync(this.myClusterType, serverState.getServer(), connection, serverState);
                        long l3 = 0L;
                        ServerState serverState2 = null;
                        if (serverState.addConnection(connection)) {
                            connection = null;
                            l3 = serverState.getConnectionGeneration();
                            serverState2 = serverState;
                        }
                        Thread.sleep(TimeUnit.MILLISECONDS.toMillis(l2));
                        if (serverState2 == null || l3 != serverState2.getConnectionGeneration() || (connection2 = serverState2.takeConnection()) == null) continue;
                        connection2.shutdown();
                    }
                    catch (IOException iOException) {
                        LOG.info("Could not ping '" + string + "': " + iOException.getMessage());
                    }
                    finally {
                        this.myPingThread.setName("MongoDB Pinger - Idle");
                        if (connection == null) continue;
                        connection.shutdown();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LOG.fine("Closing pinger on interrupt.");
            }
        }
    }

    public void setIntervalUnits(TimeUnit timeUnit) {
        this.myIntervalUnits = timeUnit;
    }

    public void setPingSweepInterval(int n) {
        this.myPingSweepInterval = n;
    }

    public void start() {
        this.myPingThread.start();
    }

    public void stop() {
        this.close();
    }

    protected static final class Pinger {
        protected Pinger() {
        }

        public boolean ping(InetSocketAddress inetSocketAddress, Connection connection, ServerState serverState) {
            try {
                Future<Reply> future = this.pingAsync(ClusterType.STAND_ALONE, inetSocketAddress, connection, serverState);
                if (future != null) {
                    future.get(1L, TimeUnit.MINUTES);
                    return true;
                }
            }
            catch (ExecutionException executionException) {
                LOG.log(Level.INFO, "Could not ping '" + inetSocketAddress + "': " + executionException.getMessage(), executionException);
            }
            catch (TimeoutException timeoutException) {
                LOG.log(Level.INFO, "'" + inetSocketAddress + "' might be a zombie - not receiving " + "a response to ping: " + timeoutException.getMessage(), timeoutException);
            }
            catch (InterruptedException interruptedException) {
                LOG.log(Level.INFO, "Interrupted pinging '" + inetSocketAddress + "': " + interruptedException.getMessage(), interruptedException);
            }
            return false;
        }

        public Future<Reply> pingAsync(ClusterType clusterType, InetSocketAddress inetSocketAddress, Connection connection, ServerState serverState) {
            try {
                ServerLatencyCallback serverLatencyCallback = new ServerLatencyCallback(serverState);
                connection.send(new IsMaster(), serverLatencyCallback);
                if (clusterType == ClusterType.REPLICA_SET) {
                    connection.send(new ReplicaSetStatus(), new SecondsBehindCallback(serverState));
                }
                return serverLatencyCallback;
            }
            catch (MongoDbException mongoDbException) {
                LOG.info("Could not ping '" + inetSocketAddress + "': " + mongoDbException.getMessage());
                return null;
            }
        }
    }
}

