/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.state;

import com.allanbank.mongodb.MongoClientConfiguration;
import com.allanbank.mongodb.ReadPreference;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.state.ServerLatencyComparator;
import com.allanbank.mongodb.connection.state.ServerState;
import com.allanbank.mongodb.util.IOUtils;
import com.allanbank.mongodb.util.ServerNameUtils;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ClusterState
implements Closeable {
    protected final ConcurrentMap<String, ServerState> myServers;
    private final PropertyChangeSupport myChangeSupport;
    private final MongoClientConfiguration myConfig;
    private final List<ServerState> myNonWritableServers;
    private final List<ServerState> myWritableServers;

    public ClusterState(MongoClientConfiguration mongoClientConfiguration) {
        this.myConfig = mongoClientConfiguration;
        this.myChangeSupport = new PropertyChangeSupport(this);
        this.myServers = new ConcurrentHashMap<String, ServerState>();
        this.myWritableServers = new CopyOnWriteArrayList<ServerState>();
        this.myNonWritableServers = new CopyOnWriteArrayList<ServerState>();
    }

    public ServerState add(String string) {
        return this.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PropertyChangeListener propertyChangeListener) {
        ClusterState clusterState = this;
        synchronized (clusterState) {
            this.myChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }
    }

    @Override
    public void close() {
        for (ServerState serverState : this.getServers()) {
            Connection connection = serverState.takeConnection();
            if (connection == null) continue;
            IOUtils.close(connection);
        }
    }

    public List<ServerState> findCandidateServers(ReadPreference readPreference) {
        List<ServerState> list = Collections.emptyList();
        switch (readPreference.getMode()) {
            case NEAREST: {
                list = this.findNearestCandidates(readPreference);
                break;
            }
            case PRIMARY_ONLY: {
                list = this.findWritableCandidates(readPreference);
                break;
            }
            case PRIMARY_PREFERRED: {
                list = this.merge(this.findWritableCandidates(readPreference), this.findNonWritableCandidates(readPreference));
                break;
            }
            case SECONDARY_ONLY: {
                list = this.findNonWritableCandidates(readPreference);
                break;
            }
            case SECONDARY_PREFERRED: {
                list = this.merge(this.findNonWritableCandidates(readPreference), this.findWritableCandidates(readPreference));
                break;
            }
            case SERVER: {
                list = this.findCandidateServer(readPreference);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerState get(String string) {
        String string2 = ServerNameUtils.normalize(string);
        ServerState serverState = (ServerState)this.myServers.get(string2);
        if (serverState == null) {
            serverState = new ServerState(ServerNameUtils.parse(string2));
            serverState.setWritable(false);
            ClusterState clusterState = this;
            synchronized (clusterState) {
                ServerState serverState2 = this.myServers.putIfAbsent(string2, serverState);
                if (serverState2 != null) {
                    serverState = serverState2;
                } else {
                    this.myNonWritableServers.add(serverState);
                    this.myChangeSupport.firePropertyChange("server", null, serverState);
                }
            }
        }
        return serverState;
    }

    public List<ServerState> getNonWritableServers() {
        return new ArrayList<ServerState>(this.myNonWritableServers);
    }

    public List<ServerState> getServers() {
        return new ArrayList<ServerState>(this.myServers.values());
    }

    public List<ServerState> getWritableServers() {
        return new ArrayList<ServerState>(this.myWritableServers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markNotWritable(ServerState serverState) {
        ClusterState clusterState = this;
        synchronized (clusterState) {
            if (serverState.setWritable(false)) {
                this.myWritableServers.remove(serverState);
                this.myNonWritableServers.add(serverState);
                this.myChangeSupport.firePropertyChange("writable", true, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markWritable(ServerState serverState) {
        ClusterState clusterState = this;
        synchronized (clusterState) {
            if (!serverState.setWritable(true)) {
                serverState.setSecondsBehind(0.0);
                this.myNonWritableServers.remove(serverState);
                this.myWritableServers.add(serverState);
                this.myChangeSupport.firePropertyChange("writable", false, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PropertyChangeListener propertyChangeListener) {
        ClusterState clusterState = this;
        synchronized (clusterState) {
            this.myChangeSupport.removePropertyChangeListener(propertyChangeListener);
        }
    }

    protected final double[] cdf(List<ServerState> list) {
        Collections.sort(list, ServerLatencyComparator.COMPARATOR);
        double[] dArray = new double[list.size()];
        double d = 0.0;
        double d2 = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < dArray.length; ++i) {
            ServerState serverState = list.get(i);
            double d3 = serverState.getAverageLatency();
            if (d2 == Double.NEGATIVE_INFINITY) {
                d2 = d3;
                d3 = 1.0;
            } else {
                d3 /= d2;
            }
            dArray[i] = d3 = 1.0 / d3;
            d += d3;
        }
        double d4 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (d4 += dArray[i]) / d;
        }
        return dArray;
    }

    protected List<ServerState> findCandidateServer(ReadPreference readPreference) {
        ServerState serverState = (ServerState)this.myServers.get(ServerNameUtils.normalize(readPreference.getServer()));
        if (serverState != null && readPreference.matches(serverState.getTags())) {
            return Collections.singletonList(serverState);
        }
        return Collections.emptyList();
    }

    protected List<ServerState> findNearestCandidates(ReadPreference readPreference) {
        ArrayList<ServerState> arrayList = new ArrayList<ServerState>(this.myServers.size());
        for (ServerState serverState : this.myServers.values()) {
            if (!readPreference.matches(serverState.getTags())) continue;
            arrayList.add(serverState);
        }
        this.sort(arrayList);
        return arrayList;
    }

    protected List<ServerState> findNonWritableCandidates(ReadPreference readPreference) {
        ArrayList<ServerState> arrayList = new ArrayList<ServerState>(this.myNonWritableServers.size());
        for (ServerState serverState : this.myNonWritableServers) {
            if (!readPreference.matches(serverState.getTags()) || !this.isRecentEnough(serverState.getSecondsBehind())) continue;
            arrayList.add(serverState);
        }
        this.sort(arrayList);
        return arrayList;
    }

    protected List<ServerState> findWritableCandidates(ReadPreference readPreference) {
        ArrayList<ServerState> arrayList = new ArrayList<ServerState>(this.myWritableServers.size());
        for (ServerState serverState : this.myWritableServers) {
            if (!readPreference.matches(serverState.getTags())) continue;
            arrayList.add(serverState);
        }
        this.sort(arrayList);
        return arrayList;
    }

    protected final void sort(List<ServerState> list) {
        double d;
        if (list.isEmpty() || list.size() == 1) {
            return;
        }
        double[] dArray = this.cdf(list);
        int n = Arrays.binarySearch(dArray, d = Math.random());
        if (n < 0) {
            n = Math.abs(n + 1);
        }
        n = Math.min(dArray.length - 1, n);
        Collections.swap(list, 0, n);
    }

    private boolean isRecentEnough(double d) {
        return d * 1000.0 < (double)this.myConfig.getMaxSecondaryLag();
    }

    private final List<ServerState> merge(List<ServerState> list, List<ServerState> list2) {
        List<ServerState> list3;
        if (list.isEmpty()) {
            list3 = list2;
        } else if (list2.isEmpty()) {
            list3 = list;
        } else {
            list3 = new ArrayList<ServerState>(list.size() + list2.size());
            list3.addAll(list);
            list3.addAll(list2);
        }
        return list3;
    }
}

