/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.state;

import com.allanbank.mongodb.connection.state.ClusterState;
import com.allanbank.mongodb.connection.state.ServerLatencyComparator;
import com.allanbank.mongodb.connection.state.ServerSelector;
import com.allanbank.mongodb.connection.state.ServerState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LatencyServerSelector
implements ServerSelector {
    private final ClusterState myCluster;
    private final boolean myWritableOnly;

    public LatencyServerSelector(ClusterState clusterState, boolean bl) {
        this.myCluster = clusterState;
        this.myWritableOnly = bl;
    }

    @Override
    public List<ServerState> pickServers() {
        List<ServerState> list = this.myWritableOnly ? this.myCluster.getWritableServers() : this.myCluster.getServers();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        list = new ArrayList<ServerState>(list);
        Collections.sort(list, ServerLatencyComparator.COMPARATOR);
        return list;
    }
}

