/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.state;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.bson.element.TimestampElement;
import com.allanbank.mongodb.connection.FutureCallback;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.connection.state.ServerState;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SecondsBehindCallback
extends FutureCallback<Reply> {
    public static final Class<DocumentElement> DOCUMENT_TYPE = DocumentElement.class;
    public static final Class<NumericElement> NUMERIC_TYPE = NumericElement.class;
    public static final int PRIMARY_STATE = 1;
    public static final int SECONDARY_STATE = 2;
    public static final Class<TimestampElement> TIMESTAMP_TYPE = TimestampElement.class;
    private final ServerState myServer;

    public SecondsBehindCallback(ServerState serverState) {
        this.myServer = serverState;
    }

    @Override
    public void callback(Reply reply) {
        if (this.myServer != null) {
            this.updateSecondsBehind(reply);
        }
        super.callback(reply);
    }

    @Override
    public void exception(Throwable throwable) {
        if (this.myServer != null) {
            this.myServer.setSecondsBehind(2.147483647E9);
        }
    }

    private void updateSecondsBehind(Reply reply) {
        List<Document> list = reply.getResults();
        if (list.size() >= 1) {
            Document document = list.get(0);
            NumericElement numericElement = document.get(NUMERIC_TYPE, "myState");
            if (numericElement != null && (numericElement.getIntValue() == 1 || numericElement.getIntValue() == 2)) {
                TimestampElement timestampElement = null;
                StringElement stringElement = new StringElement("name", this.myServer.getName());
                for (DocumentElement object : document.find(DOCUMENT_TYPE, "members", ".*")) {
                    if (!stringElement.equals(object.get("name")) || object.get(TIMESTAMP_TYPE, "optimeDate") == null) continue;
                    timestampElement = object.get(TIMESTAMP_TYPE, "optimeDate");
                }
                if (timestampElement != null) {
                    Object object = timestampElement;
                    for (TimestampElement timestampElement2 : document.find(TIMESTAMP_TYPE, "members", ".*", "optimeDate")) {
                        if (((TimestampElement)object).getTime() >= timestampElement2.getTime()) continue;
                        object = timestampElement2;
                    }
                    double d = ((TimestampElement)object).getTime() - timestampElement.getTime();
                    this.myServer.setSecondsBehind(d / (double)TimeUnit.SECONDS.toMillis(1L));
                }
            } else {
                this.myServer.setSecondsBehind(Double.MAX_VALUE);
            }
        }
    }
}

