/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.state;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.element.BooleanElement;
import com.allanbank.mongodb.bson.element.DocumentElement;
import com.allanbank.mongodb.connection.FutureCallback;
import com.allanbank.mongodb.connection.message.Reply;
import com.allanbank.mongodb.connection.state.ServerState;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class ServerLatencyCallback
extends FutureCallback<Reply> {
    private final ServerState myServer;
    private final long myStartTimeNanos;

    public ServerLatencyCallback(ServerState serverState) {
        this.myServer = serverState;
        this.myStartTimeNanos = System.nanoTime();
    }

    @Override
    public void callback(Reply reply) {
        long l = System.nanoTime();
        double d = l - this.myStartTimeNanos;
        double d2 = d / (double)TimeUnit.MILLISECONDS.toNanos(1L);
        if (this.myServer != null && this.isReadable(reply)) {
            this.myServer.updateAverageLatency(d2);
            this.myServer.setTags(this.extractTags(reply));
        }
        super.callback(reply);
    }

    private Document extractTags(Reply reply) {
        Document document = null;
        List<Document> list = reply.getResults();
        if (list.size() >= 1) {
            Document document2 = list.get(0);
            List<DocumentElement> list2 = document2.find(DocumentElement.class, "tags");
            if (!list2.isEmpty()) {
                document = list2.get(0).asDocument();
            }
        }
        return document;
    }

    private boolean isReadable(Reply reply) {
        List<Document> list = reply.getResults();
        if (list.size() >= 1) {
            Document document = list.get(0);
            List<BooleanElement> list2 = document.find(BooleanElement.class, "ismaster|secondary");
            for (BooleanElement booleanElement : list2) {
                if (!booleanElement.getValue()) continue;
                return true;
            }
        }
        return false;
    }
}

