/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.state;

import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.util.ServerNameUtils;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ServerState {
    public static final double DECAY_ALPHA = 0.001998001998001998;
    public static final double DECAY_SAMPLES = 1000.0;
    public static final int DEFAULT_PORT = 27017;
    private final AtomicLong myAverageLatency;
    private final AtomicReference<Connection> myConnection;
    private final AtomicLong myConnectionGeneration;
    private final String myName;
    private final AtomicLong mySecondsBehind;
    private final InetSocketAddress myServer;
    private final AtomicReference<Document> myTags;
    private final AtomicBoolean myWritable;

    public ServerState(InetSocketAddress inetSocketAddress) {
        this.myServer = inetSocketAddress;
        this.myName = ServerNameUtils.normalize(inetSocketAddress);
        this.myWritable = new AtomicBoolean(false);
        this.myAverageLatency = new AtomicLong(Double.doubleToLongBits(Double.MAX_VALUE));
        this.mySecondsBehind = new AtomicLong(Double.doubleToLongBits(Double.MAX_VALUE));
        this.myTags = new AtomicReference<Object>(null);
        this.myConnection = new AtomicReference<Object>(null);
        this.myConnectionGeneration = new AtomicLong(0L);
    }

    public boolean addConnection(Connection connection) {
        boolean bl = this.myConnection.compareAndSet(null, connection);
        if (bl) {
            this.myConnectionGeneration.incrementAndGet();
        }
        return bl;
    }

    public double getAverageLatency() {
        return Double.longBitsToDouble(this.myAverageLatency.get());
    }

    public long getConnectionGeneration() {
        return this.myConnectionGeneration.get();
    }

    public String getName() {
        return this.myName;
    }

    public double getSecondsBehind() {
        return Double.longBitsToDouble(this.mySecondsBehind.get());
    }

    public InetSocketAddress getServer() {
        return this.myServer;
    }

    public Document getTags() {
        return this.myTags.get();
    }

    public boolean isWritable() {
        return this.myWritable.get();
    }

    public void setAverageLatency(double d) {
        this.myAverageLatency.set(Double.doubleToLongBits(d));
    }

    public void setSecondsBehind(double d) {
        this.mySecondsBehind.set(Double.doubleToLongBits(d));
    }

    public void setTags(Document document) {
        this.myTags.set(document);
    }

    public Connection takeConnection() {
        return this.myConnection.getAndSet(null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.myName);
        stringBuilder.append("(");
        if (this.myWritable.get()) {
            stringBuilder.append("W,");
        }
        if (this.myTags.get() != null) {
            stringBuilder.append("T,");
        }
        stringBuilder.append(this.getAverageLatency());
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void updateAverageLatency(double d) {
        double d2 = Double.longBitsToDouble(this.myAverageLatency.get());
        if (Double.MAX_VALUE == d2) {
            this.myAverageLatency.set(Double.doubleToLongBits(d));
            this.mySecondsBehind.compareAndSet(Double.doubleToLongBits(Double.MAX_VALUE), Double.doubleToLongBits(0.0));
        } else {
            double d3 = DECAY_ALPHA * d + (1.0 - DECAY_ALPHA) * d2;
            this.myAverageLatency.set(Double.doubleToLongBits(d3));
        }
    }

    boolean setWritable(boolean bl) {
        return this.myWritable.getAndSet(bl);
    }
}

