/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.connection.state;

import com.allanbank.mongodb.connection.Connection;
import com.allanbank.mongodb.connection.state.AbstractReconnectStrategy;
import com.allanbank.mongodb.connection.state.ServerState;
import com.allanbank.mongodb.util.IOUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.logging.Logger;

public class SimpleReconnectStrategy
extends AbstractReconnectStrategy {
    protected static final Logger LOG = Logger.getLogger(SimpleReconnectStrategy.class.getCanonicalName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection reconnect(Connection connection) {
        List<ServerState> list = this.getSelector().pickServers();
        boolean bl = Thread.interrupted();
        try {
            for (ServerState serverState : list) {
                Connection connection2;
                block9: {
                    connection2 = null;
                    InetSocketAddress inetSocketAddress = serverState.getServer();
                    connection2 = this.getConnectionFactory().connect(serverState, this.getConfig());
                    if (!this.isConnected(serverState, connection2)) break block9;
                    LOG.info("Reconnected to " + inetSocketAddress);
                    this.copyPending(connection2, connection);
                    Connection connection3 = connection2;
                    return connection3;
                }
                try {
                    IOUtils.close(connection2);
                }
                catch (IOException iOException) {
                    LOG.fine("Reconnect to " + serverState + " failed: " + iOException.getMessage());
                }
            }
        }
        finally {
            if (bl) {
                Thread.currentThread().interrupt();
            }
        }
        LOG.info("Reconnect attempt failed for all " + list.size() + " servers: " + list);
        return null;
    }
}

