/*
 * Decompiled with CFR 0.152.
 */
package com.allanbank.mongodb.gridfs;

import com.allanbank.mongodb.Durability;
import com.allanbank.mongodb.MongoCollection;
import com.allanbank.mongodb.MongoDatabase;
import com.allanbank.mongodb.MongoDbException;
import com.allanbank.mongodb.MongoDbUri;
import com.allanbank.mongodb.MongoFactory;
import com.allanbank.mongodb.MongoIterator;
import com.allanbank.mongodb.bson.Document;
import com.allanbank.mongodb.bson.Element;
import com.allanbank.mongodb.bson.NumericElement;
import com.allanbank.mongodb.bson.builder.BuilderFactory;
import com.allanbank.mongodb.bson.builder.DocumentBuilder;
import com.allanbank.mongodb.bson.element.BinaryElement;
import com.allanbank.mongodb.bson.element.ObjectId;
import com.allanbank.mongodb.bson.element.StringElement;
import com.allanbank.mongodb.builder.Find;
import com.allanbank.mongodb.builder.Index;
import com.allanbank.mongodb.builder.QueryBuilder;
import com.allanbank.mongodb.builder.Sort;
import com.allanbank.mongodb.util.IOUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class GridFs {
    public static final String CHUNK_NUMBER_FIELD = "n";
    public static final String CHUNK_SIZE_FIELD = "chunkSize";
    public static final String CHUNKS_SUFFIX = ".chunks";
    public static final String DATA_FIELD = "data";
    public static final int DEFAULT_CHUNK_SIZE = 262144;
    public static final String DEFAULT_ROOT = "fs";
    public static final String FILENAME_FIELD = "filename";
    public static final String FILES_ID_FIELD = "files_id";
    public static final String FILES_SUFFIX = ".files";
    public static final String ID_FIELD = "_id";
    public static final String LENGTH_FIELD = "length";
    public static final String MD5_FIELD = "md5";
    public static final String UPLOAD_DATE_FIELD = "uploadDate";
    private final MongoCollection myChunksCollection;
    private int myChunkSize = 262144;
    private final MongoDatabase myDatabase;
    private final MongoCollection myFilesCollection;
    private final String myRootName;

    public GridFs(MongoDatabase mongoDatabase) {
        this(mongoDatabase, DEFAULT_ROOT);
    }

    public GridFs(MongoDatabase mongoDatabase, String string) {
        this.myRootName = string;
        this.myDatabase = mongoDatabase;
        this.myFilesCollection = mongoDatabase.getCollection(string + FILES_SUFFIX);
        this.myChunksCollection = mongoDatabase.getCollection(string + CHUNKS_SUFFIX);
    }

    public GridFs(String string) {
        this(string, DEFAULT_ROOT);
    }

    public GridFs(String string, String string2) {
        MongoDbUri mongoDbUri = new MongoDbUri(string);
        MongoDatabase mongoDatabase = MongoFactory.createClient(mongoDbUri).getDatabase(mongoDbUri.getDatabase());
        this.myRootName = string2;
        this.myDatabase = mongoDatabase;
        this.myFilesCollection = mongoDatabase.getCollection(string2 + FILES_SUFFIX);
        this.myChunksCollection = mongoDatabase.getCollection(string2 + CHUNKS_SUFFIX);
    }

    public void createIndexes() {
        try {
            this.myFilesCollection.createIndex(true, Index.asc(FILENAME_FIELD), Index.asc(UPLOAD_DATE_FIELD));
        }
        catch (MongoDbException mongoDbException) {
            this.myFilesCollection.createIndex(false, Index.asc(FILENAME_FIELD), Index.asc(UPLOAD_DATE_FIELD));
        }
        try {
            this.myChunksCollection.createIndex(true, Index.asc(FILES_ID_FIELD), Index.asc(CHUNK_NUMBER_FIELD));
        }
        catch (MongoDbException mongoDbException) {
            this.myChunksCollection.createIndex(false, Index.asc(FILES_ID_FIELD), Index.asc(CHUNK_NUMBER_FIELD));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Object, List<String>> fsck(boolean bl) throws IOException {
        HashMap<Object, List<String>> hashMap = new HashMap<Object, List<String>>();
        this.createIndexes();
        MongoIterator<Document> mongoIterator = this.myFilesCollection.find(Find.ALL);
        try {
            for (Document document : mongoIterator) {
                Element element = document.get(ID_FIELD);
                DocumentBuilder documentBuilder = BuilderFactory.start();
                documentBuilder.add(element.withName("filemd5"));
                documentBuilder.add("root", this.myRootName);
                Document document2 = this.myDatabase.runCommand(documentBuilder.build());
                if (this.doVerifyFileMd5(hashMap, document, document2) || !bl) continue;
                this.doTryAndRepair(document, hashMap);
            }
        }
        finally {
            mongoIterator.close();
        }
        return hashMap;
    }

    public int getChunkSize() {
        return this.myChunkSize;
    }

    public void read(ObjectId objectId, OutputStream outputStream) throws IOException {
        Document document = this.myFilesCollection.findOne(QueryBuilder.where(ID_FIELD).equals(objectId));
        if (document == null) {
            throw new FileNotFoundException(objectId.toString());
        }
        this.doRead(document, outputStream);
    }

    public void read(String string, OutputStream outputStream) throws IOException {
        Document document = this.myFilesCollection.findOne(QueryBuilder.where(FILENAME_FIELD).equals(string));
        if (document == null) {
            throw new FileNotFoundException(string);
        }
        this.doRead(document, outputStream);
    }

    public void setChunkSize(int n) {
        this.myChunkSize = n;
    }

    public boolean unlink(ObjectId objectId) throws IOException {
        Document document = this.myFilesCollection.findOne(QueryBuilder.where(ID_FIELD).equals(objectId));
        if (document == null) {
            return false;
        }
        return this.doUnlink(document);
    }

    public boolean unlink(String string) throws IOException {
        Document document = this.myFilesCollection.findOne(QueryBuilder.where(FILENAME_FIELD).equals(string));
        if (document == null) {
            return false;
        }
        return this.doUnlink(document);
    }

    public boolean validate(ObjectId objectId) throws IOException {
        Document document = this.myFilesCollection.findOne(QueryBuilder.where(ID_FIELD).equals(objectId));
        if (document == null) {
            throw new FileNotFoundException(objectId.toString());
        }
        return this.doValidate(document);
    }

    public boolean validate(String string) throws IOException {
        Document document = this.myFilesCollection.findOne(QueryBuilder.where(FILENAME_FIELD).equals(string));
        if (document == null) {
            throw new FileNotFoundException(string);
        }
        return this.doValidate(document);
    }

    public ObjectId write(String string, InputStream inputStream) throws IOException {
        ObjectId objectId = new ObjectId();
        boolean bl = false;
        try {
            Object object;
            Object object2;
            byte[] byArray = new byte[this.myChunkSize];
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            ArrayList<Future<Integer>> arrayList = new ArrayList<Future<Integer>>();
            DocumentBuilder documentBuilder = BuilderFactory.start();
            int n = 0;
            long l = 0L;
            int n2 = this.readFully(inputStream, byArray);
            while (n2 > 0) {
                object2 = new ObjectId();
                documentBuilder.reset();
                documentBuilder.addObjectId(ID_FIELD, (ObjectId)object2);
                documentBuilder.addObjectId(FILES_ID_FIELD, objectId);
                documentBuilder.addInteger(CHUNK_NUMBER_FIELD, n);
                object = n2 == byArray.length ? byArray : Arrays.copyOf(byArray, n2);
                messageDigest.update((byte[])object);
                documentBuilder.addBinary(DATA_FIELD, (byte[])object);
                arrayList.add(this.myChunksCollection.insertAsync(documentBuilder.build()));
                l += (long)((byte[])object).length;
                n2 = this.readFully(inputStream, byArray);
                ++n;
            }
            documentBuilder.reset();
            documentBuilder.addObjectId(ID_FIELD, objectId);
            documentBuilder.addString(FILENAME_FIELD, string);
            documentBuilder.addTimestamp(UPLOAD_DATE_FIELD, System.currentTimeMillis());
            documentBuilder.addInteger(CHUNK_SIZE_FIELD, byArray.length);
            documentBuilder.addLong(LENGTH_FIELD, l);
            documentBuilder.addString(MD5_FIELD, IOUtils.toHex(messageDigest.digest()));
            arrayList.add(this.myFilesCollection.insertAsync(documentBuilder.build()));
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (Future)object2.next();
                object.get();
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            bl = true;
            throw new IOException(noSuchAlgorithmException);
        }
        catch (InterruptedException interruptedException) {
            bl = true;
            InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getMessage());
            interruptedIOException.initCause(interruptedException);
            throw interruptedIOException;
        }
        catch (ExecutionException executionException) {
            bl = true;
            throw new IOException(executionException.getCause());
        }
        finally {
            if (bl) {
                this.myFilesCollection.delete(QueryBuilder.where(ID_FIELD).equals(objectId));
                this.myChunksCollection.delete(QueryBuilder.where(FILES_ID_FIELD).equals(objectId));
            }
        }
        return objectId;
    }

    protected void doAddFault(Map<Object, List<String>> map, Element element, String string) {
        List<String> list = map.get(element.getValueAsObject());
        if (list == null) {
            list = new ArrayList<String>();
            map.put(element.getValueAsObject(), list);
        }
        list.add(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRead(Document document, OutputStream outputStream) throws IOException {
        Element element = document.get(ID_FIELD);
        long l = -1L;
        NumericElement numericElement = document.get(NumericElement.class, LENGTH_FIELD);
        if (numericElement != null) {
            l = numericElement.getLongValue();
        }
        long l2 = -1L;
        NumericElement numericElement2 = document.get(NumericElement.class, CHUNK_SIZE_FIELD);
        if (numericElement2 != null) {
            l2 = numericElement2.getLongValue();
        }
        long l3 = -1L;
        if (0L <= l && 0L < l2) {
            l3 = (long)Math.ceil((double)l / (double)l2);
        }
        Element element2 = element.withName(FILES_ID_FIELD);
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add(element2);
        Find.Builder builder = new Find.Builder(documentBuilder.build());
        builder.setSort(Sort.asc(CHUNK_NUMBER_FIELD));
        builder.setBatchSize(2);
        long l4 = 0L;
        long l5 = 0L;
        MongoIterator<Document> mongoIterator = this.myChunksCollection.find(builder.build());
        try {
            for (Document document2 : mongoIterator) {
                NumericElement numericElement3 = document2.get(NumericElement.class, CHUNK_NUMBER_FIELD);
                BinaryElement binaryElement = document2.get(BinaryElement.class, DATA_FIELD);
                if (numericElement3 == null) {
                    throw new IOException("Missing chunk number '" + (l4 + 1L) + "' of '" + l3 + "'.");
                }
                if (numericElement3.getLongValue() != l4) {
                    throw new IOException("Skipped chunk '" + (l4 + 1L) + "', retreived '" + numericElement3.getLongValue() + "' of '" + l3 + "'.");
                }
                if (binaryElement == null) {
                    throw new IOException("Missing bytes in chunk '" + (l4 + 1L) + "' of '" + l3 + "'.");
                }
                byte[] byArray = binaryElement.getValue();
                outputStream.write(byArray);
                ++l4;
                l5 += (long)byArray.length;
            }
        }
        finally {
            mongoIterator.close();
            outputStream.flush();
        }
        if (0L <= l3 && l4 < l3) {
            throw new IOException("Missing chunks after '" + l4 + "' of '" + l3 + "'.");
        }
        if (0L <= l && l5 != l) {
            throw new IOException("File size mismatch. Expected '" + l + "' but only read '" + l5 + "' bytes.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTryAndRepair(Document document, Map<Object, List<String>> map) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element element = document.get(ID_FIELD);
        Element element2 = document.get(MD5_FIELD);
        Element element3 = element.withName(FILES_ID_FIELD);
        DocumentBuilder documentBuilder = BuilderFactory.start().add(element3);
        Find.Builder builder = new Find.Builder(documentBuilder.build());
        builder.setSort(Sort.asc(ID_FIELD));
        builder.setBatchSize(2);
        MongoIterator<Document> mongoIterator = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            mongoIterator = this.myChunksCollection.find(builder);
            for (Document serializable2 : mongoIterator) {
                arrayList.add(serializable2.get(ID_FIELD));
                BinaryElement n = serializable2.get(BinaryElement.class, DATA_FIELD);
                if (n == null) continue;
                messageDigest.update(n.getValue());
            }
            String string = IOUtils.toHex(messageDigest.digest());
            StringElement stringElement = new StringElement(MD5_FIELD, string);
            if (stringElement.equals(element2)) {
                int n = 0;
                for (Element element4 : arrayList) {
                    DocumentBuilder documentBuilder2 = BuilderFactory.start();
                    documentBuilder2.add(element4);
                    documentBuilder2.add(element3);
                    DocumentBuilder documentBuilder3 = BuilderFactory.start();
                    documentBuilder3.push("$set").add(CHUNK_NUMBER_FIELD, n);
                    this.myChunksCollection.update(documentBuilder2.build(), documentBuilder3.build(), true, false, Durability.ACK);
                    ++n;
                }
                if (this.doValidate(document)) {
                    this.doAddFault(map, element, "File repaired.");
                } else {
                    this.doAddFault(map, element, "Repair failed: Chunks reordered but sill not validating.");
                }
            } else {
                this.doAddFault(map, element, "Repair failed: Could not determine correct chunk order.");
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.doAddFault(map, element, "Repair failed: Could not compute the MD5 for the file: " + noSuchAlgorithmException.getMessage());
        }
        catch (RuntimeException runtimeException) {
            this.doAddFault(map, element, "Potential Repair Failure: Runtime error: " + runtimeException.getMessage());
        }
        finally {
            IOUtils.close(mongoIterator);
        }
    }

    protected boolean doUnlink(Document document) throws IOException {
        Element element = document.get(ID_FIELD);
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add(element.withName(FILES_ID_FIELD));
        Future<Long> future = this.myChunksCollection.deleteAsync(documentBuilder);
        documentBuilder.reset();
        documentBuilder.add(element);
        Future<Long> future2 = this.myFilesCollection.deleteAsync(documentBuilder);
        try {
            return future.get() >= 0L && future2.get() > 0L;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (ExecutionException executionException) {
            return false;
        }
    }

    protected boolean doValidate(Document document) {
        Element element = document.get(ID_FIELD);
        Element element2 = document.get(MD5_FIELD);
        DocumentBuilder documentBuilder = BuilderFactory.start();
        documentBuilder.add(element.withName("filemd5"));
        documentBuilder.add("root", this.myRootName);
        Document document2 = this.myDatabase.runCommand(documentBuilder.build());
        return element2 != null && element2.equals(document2.findFirst(MD5_FIELD));
    }

    protected boolean doVerifyFileMd5(Map<Object, List<String>> map, Document document, Document document2) {
        boolean bl = false;
        Element element = document.get(ID_FIELD);
        Element element2 = document.get(MD5_FIELD);
        Element element3 = document2.findFirst(MD5_FIELD);
        boolean bl2 = bl = element2 != null && element2.equals(element3);
        if (!bl) {
            this.doAddFault(map, element, "MD5 sums do not match. File document contains '" + element2 + "' and the filemd5 command produced '" + element3 + "'.");
        }
        return bl;
    }

    private int readFully(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        do {
            if ((n = inputStream.read(byArray, n2, byArray.length - n2)) >= 0) continue;
            return n2;
        } while ((n2 += n) != byArray.length);
        return n2;
    }
}

